(*
% File     : KRS057+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A possible mapping of the EquivalentClasses axiom
% Version  : Especial.
% English  : A possible mapping of the EquivalentClasses axiom, which is 
%            connected but without a Hamiltonian path.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_equivalentClass-Manifest009 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   1 unit)
%            Number of atoms       :   38 (  10 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   32 (   5 ~  ;   0  |;  13  &)
%                                         (   7 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   17 (   0 singleton;  17 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cD_ : Universe -> Prop.
Variable EqCongruence_cD : forall x1 y1 : Universe, x1 = y1 -> cD_ x1 -> cD_ y1 .
Variable cC_ : Universe -> Prop.
Variable EqCongruence_cC : forall x1 y1 : Universe, x1 = y1 -> cC_ x1 -> cC_ y1 .
Variable cB_ : Universe -> Prop.
Variable EqCongruence_cB : forall x1 y1 : Universe, x1 = y1 -> cB_ x1 -> cB_ y1 .

Variable iA_ : Universe.

Variable cB_substitution_1_1 : (forall A B : Universe, ((A = B /\ cB_ A) -> cB_ B)).
Variable cC_substitution_1_2 : (forall A B : Universe, ((A = B /\ cC_ A) -> cC_ B)).
Variable cD_substitution_1_3 : (forall A B : Universe, ((A = B /\ cD_ A) -> cD_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : cowlThing_ iA_.
Variable axiom_3_11 : (forall X : Universe, ((cB_ X <-> cC_ X) /\ ((cB_ X <-> X = iA_) /\ ((cB_ X <-> ~(cD_ X)) /\ ((cC_ X <-> X = iA_) /\ ((cC_ X <-> ~(cD_ X)) /\ (X = iA_ <-> ~(cD_ X)))))))).

Theorem conjecture_12 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
