(*
% File     : KRS056+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : owl:disjointWith edges may be within OWL DL
% Version  : Especial.
% English  : If the owl:disjointWith edges in the graph form undirected 
%            complete subgraphs which share URIref nodes but do not share 
%            blank node then this may be within OWL DL.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_disjointWith-Manifest009 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   20 (   8 ~  ;   0  |;  11  &)
%                                         (   1 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    4 (   0 singleton;   4 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cD_ : Universe -> Prop.
Variable cC_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.


Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (~((cC_ X /\ cD_ X)) /\ (~((cC_ X /\ cA_ X)) /\ ~((cD_ X /\ cA_ X))))).
Variable axiom_3_4 : (forall X : Universe, (~((cD_ X /\ cB_ X)) /\ (~((cD_ X /\ cA_ X)) /\ ~((cB_ X /\ cA_ X))))).

Theorem conjecture_5 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
