(*
% File     : KRS052+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Integer multiplication in OWL DL, interacting with infinity
% Version  : Especial.
% English  : N times infinity is 2  times infinity. 
%            M times infinity is 3 times infinity. 
%            N times M times infinity is 5 times infinity.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest908 [Bec03]
% Status   : Satisfiable
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   39 (   0 unit)
%            Number of atoms       :  161 (  60 equality)
%            Maximal formula depth :   25 (   6 average)
%            Number of connectives :  138 (  16 ~  ;  21  |;  60  &)
%                                         (  10 <=>;  31 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   14 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :  111 (   0 singleton;  98 !;  13 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_N_times_M_to_1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr_N_times_M_to_1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_N_times_M_to_1_ x1 x2 -> rr_N_times_M_to_1_ y1 y2 .
Variable rq_M_to_1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rq_M_to_1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rq_M_to_1_ x1 x2 -> rq_M_to_1_ y1 y2 .
Variable rp_N_to_1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rp_N_to_1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rp_N_to_1_ x1 x2 -> rp_N_to_1_ y1 y2 .
Variable rinvR_N_times_M_to_1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvR_N_times_M_to_1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvR_N_times_M_to_1_ x1 x2 -> rinvR_N_times_M_to_1_ y1 y2 .
Variable rinvQ_1_to_M_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvQ_1_to_M : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvQ_1_to_M_ x1 x2 -> rinvQ_1_to_M_ y1 y2 .
Variable rinvP_1_to_N_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvP_1_to_N : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvP_1_to_N_ x1 x2 -> rinvP_1_to_N_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cinfinite_ : Universe -> Prop.
Variable EqCongruence_cinfinite : forall x1 y1 : Universe, x1 = y1 -> cinfinite_ x1 -> cinfinite_ y1 .
Variable ccardinality_N_times_M_ : Universe -> Prop.
Variable EqCongruence_ccardinality_N_times_M : forall x1 y1 : Universe, x1 = y1 -> ccardinality_N_times_M_ x1 -> ccardinality_N_times_M_ y1 .
Variable ccardinality_N_ : Universe -> Prop.
Variable EqCongruence_ccardinality_N : forall x1 y1 : Universe, x1 = y1 -> ccardinality_N_ x1 -> ccardinality_N_ y1 .


Variable ccardinality_N_substitution_1_1 : (forall A B : Universe, ((A = B /\ ccardinality_N_ A) -> ccardinality_N_ B)).
Variable ccardinality_N_times_M_substitution_1_2 : (forall A B : Universe, ((A = B /\ ccardinality_N_times_M_ A) -> ccardinality_N_times_M_ B)).
Variable cinfinite_substitution_1_3 : (forall A B : Universe, ((A = B /\ cinfinite_ A) -> cinfinite_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rinvP_1_to_N_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rinvP_1_to_N_ A C) -> rinvP_1_to_N_ B C)).
Variable rinvP_1_to_N_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rinvP_1_to_N_ C A) -> rinvP_1_to_N_ C B)).
Variable rinvQ_1_to_M_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rinvQ_1_to_M_ A C) -> rinvQ_1_to_M_ B C)).
Variable rinvQ_1_to_M_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rinvQ_1_to_M_ C A) -> rinvQ_1_to_M_ C B)).
Variable rinvR_N_times_M_to_1_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rinvR_N_times_M_to_1_ A C) -> rinvR_N_times_M_to_1_ B C)).
Variable rinvR_N_times_M_to_1_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rinvR_N_times_M_to_1_ C A) -> rinvR_N_times_M_to_1_ C B)).
Variable rp_N_to_1_substitution_1_12 : (forall A B C : Universe, ((A = B /\ rp_N_to_1_ A C) -> rp_N_to_1_ B C)).
Variable rp_N_to_1_substitution_2_13 : (forall A B C : Universe, ((A = B /\ rp_N_to_1_ C A) -> rp_N_to_1_ C B)).
Variable rq_M_to_1_substitution_1_14 : (forall A B C : Universe, ((A = B /\ rq_M_to_1_ A C) -> rq_M_to_1_ B C)).
Variable rq_M_to_1_substitution_2_15 : (forall A B C : Universe, ((A = B /\ rq_M_to_1_ C A) -> rq_M_to_1_ C B)).
Variable rr_N_times_M_to_1_substitution_1_16 : (forall A B C : Universe, ((A = B /\ rr_N_times_M_to_1_ A C) -> rr_N_times_M_to_1_ B C)).
Variable rr_N_times_M_to_1_substitution_2_17 : (forall A B C : Universe, ((A = B /\ rr_N_times_M_to_1_ C A) -> rr_N_times_M_to_1_ C B)).
Variable xsd_integer_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_19 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_20 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_21 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_22 : (forall X : Universe, (ccardinality_N_ X <-> ((exists Y0 Y1 Y2 : Universe, (rinvQ_1_to_M_ X Y0 /\ (rinvQ_1_to_M_ X Y1 /\ (rinvQ_1_to_M_ X Y2 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ Y1 <> Y2)))))) /\ (forall Y0 Y1 Y2 Y3 : Universe, ((rinvQ_1_to_M_ X Y0 /\ (rinvQ_1_to_M_ X Y1 /\ (rinvQ_1_to_M_ X Y2 /\ rinvQ_1_to_M_ X Y3))) -> (Y0 = Y1 \/ (Y0 = Y2 \/ (Y0 = Y3 \/ (Y1 = Y2 \/ (Y1 = Y3 \/ Y2 = Y3)))))))))).
Variable axiom_3_23 : (forall X : Universe, (ccardinality_N_ X <-> (exists Y : Universe, (rp_N_to_1_ X Y /\ cinfinite_ Y)))).
Variable axiom_4_24 : (forall X : Universe, (ccardinality_N_times_M_ X <-> (exists Y : Universe, (rq_M_to_1_ X Y /\ ccardinality_N_ Y)))).
Variable axiom_5_25 : (forall X : Universe, (ccardinality_N_times_M_ X <-> (exists Y : Universe, (rr_N_times_M_to_1_ X Y /\ cinfinite_ Y)))).
Variable axiom_6_26 : (forall X : Universe, (cinfinite_ X <-> ((exists Y0 Y1 Y2 Y3 Y4 : Universe, (rinvR_N_times_M_to_1_ X Y0 /\ (rinvR_N_times_M_to_1_ X Y1 /\ (rinvR_N_times_M_to_1_ X Y2 /\ (rinvR_N_times_M_to_1_ X Y3 /\ (rinvR_N_times_M_to_1_ X Y4 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ (Y0 <> Y3 /\ (Y0 <> Y4 /\ (Y1 <> Y2 /\ (Y1 <> Y3 /\ (Y1 <> Y4 /\ (Y2 <> Y3 /\ (Y2 <> Y4 /\ Y3 <> Y4))))))))))))))) /\ (forall Y0 Y1 Y2 Y3 Y4 Y5 : Universe, ((rinvR_N_times_M_to_1_ X Y0 /\ (rinvR_N_times_M_to_1_ X Y1 /\ (rinvR_N_times_M_to_1_ X Y2 /\ (rinvR_N_times_M_to_1_ X Y3 /\ (rinvR_N_times_M_to_1_ X Y4 /\ rinvR_N_times_M_to_1_ X Y5))))) -> (Y0 = Y1 \/ (Y0 = Y2 \/ (Y0 = Y3 \/ (Y0 = Y4 \/ (Y0 = Y5 \/ (Y1 = Y2 \/ (Y1 = Y3 \/ (Y1 = Y4 \/ (Y1 = Y5 \/ (Y2 = Y3 \/ (Y2 = Y4 \/ (Y2 = Y5 \/ (Y3 = Y4 \/ (Y3 = Y5 \/ Y4 = Y5))))))))))))))))))).
Variable axiom_7_27 : (forall X : Universe, (cinfinite_ X <-> ((exists Y0 Y1 : Universe, (rinvP_1_to_N_ X Y0 /\ (rinvP_1_to_N_ X Y1 /\ Y0 <> Y1))) /\ (forall Y0 Y1 Y2 : Universe, ((rinvP_1_to_N_ X Y0 /\ (rinvP_1_to_N_ X Y1 /\ rinvP_1_to_N_ X Y2)) -> (Y0 = Y1 \/ (Y0 = Y2 \/ Y1 = Y2))))))).
Variable axiom_8_28 : (forall X Y Z : Universe, ((rp_N_to_1_ X Y /\ rp_N_to_1_ X Z) -> Y = Z)).
Variable axiom_9_29 : (forall X Y : Universe, (rp_N_to_1_ X Y -> ccardinality_N_ X)).
Variable axiom_10_30 : (forall X Y : Universe, (rp_N_to_1_ X Y -> cinfinite_ Y)).
Variable axiom_11_31 : (forall X Y : Universe, (rp_N_to_1_ X Y <-> rinvP_1_to_N_ Y X)).
Variable axiom_12_32 : (forall X Y Z : Universe, ((rq_M_to_1_ X Y /\ rq_M_to_1_ X Z) -> Y = Z)).
Variable axiom_13_33 : (forall X Y : Universe, (rq_M_to_1_ X Y -> ccardinality_N_times_M_ X)).
Variable axiom_14_34 : (forall X Y : Universe, (rq_M_to_1_ X Y -> ccardinality_N_ Y)).
Variable axiom_15_35 : (forall X Y : Universe, (rq_M_to_1_ X Y <-> rinvQ_1_to_M_ Y X)).
Variable axiom_16_36 : (forall X Y Z : Universe, ((rr_N_times_M_to_1_ X Y /\ rr_N_times_M_to_1_ X Z) -> Y = Z)).
Variable axiom_17_37 : (forall X Y : Universe, (rr_N_times_M_to_1_ X Y -> ccardinality_N_times_M_ X)).
Variable axiom_18_38 : (forall X Y : Universe, (rr_N_times_M_to_1_ X Y -> cinfinite_ Y)).
Variable axiom_19_39 : (forall X Y : Universe, (rr_N_times_M_to_1_ X Y <-> rinvR_N_times_M_to_1_ Y X)).

Theorem conjecture_40 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
