(*
% File     : KRS046+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t5.1 Non-finite model example from paper
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest624 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   30 (   1 unit)
%            Number of atoms       :   85 (  19 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   58 (   3 ~  ;   0  |;  26  &)
%                                         (   7 <=>;  22 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   14 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   69 (   0 singleton;  64 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : The concept should be coherent but has no finite model
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rinvR_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvR : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvR_ x1 x2 -> rinvR_ y1 y2 .
Variable rinvF_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvF : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvF_ x1 x2 -> rinvF_ y1 y2 .
Variable rf_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf_ x1 x2 -> rf_ y1 y2 .
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable EqCongruence_ra_Px1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ra_Px1_ x1 x2 -> ra_Px1_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable caxcomp_ : Universe -> Prop.
Variable EqCongruence_caxcomp : forall x1 y1 : Universe, x1 = y1 -> caxcomp_ x1 -> caxcomp_ y1 .
Variable ca_Vx2_ : Universe -> Prop.
Variable EqCongruence_ca_Vx2 : forall x1 y1 : Universe, x1 = y1 -> ca_Vx2_ x1 -> ca_Vx2_ y1 .
Variable ca_ : Universe -> Prop.
Variable EqCongruence_ca : forall x1 y1 : Universe, x1 = y1 -> ca_ x1 -> ca_ y1 .
Variable cSatisfiable_ : Universe -> Prop.
Variable EqCongruence_cSatisfiable : forall x1 y1 : Universe, x1 = y1 -> cSatisfiable_ x1 -> cSatisfiable_ y1 .

Variable i2003_11_14_17_16_25617_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable ca_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_ A) -> ca_ B)).
Variable ca_Vx2_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Vx2_ A) -> ca_Vx2_ B)).
Variable caxcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ caxcomp_ A) -> caxcomp_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable ra_Px1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rf_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_15 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_16 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_17 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_19 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_20 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_21 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rinvF_ X Y /\ ca_ Y)) /\ (caxcomp_ X /\ (exists Y : Universe, (rinvR_ X Y /\ ca_Vx2_ Y)))))).
Variable axiom_3_22 : (forall X : Universe, (ca_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_23 : (forall X : Universe, (caxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_24 : (forall X : Universe, (ca_Vx2_ X <-> (exists Y : Universe, (rinvF_ X Y /\ ca_ Y)))).
Variable axiom_6_25 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf_ X Y0 /\ rf_ X Y1) -> Y0 = Y1)))).
Variable axiom_7_26 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_8_27 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_9_28 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_10_29 : cSatisfiable_ i2003_11_14_17_16_25617_.
Variable axiom_11_30 : (forall X Y : Universe, (rf_ X Y -> rr_ X Y)).

Theorem conjecture_31 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
