(*
% File     : KRS045+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t2.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest616 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   27 (   1 unit)
%            Number of atoms       :   76 (  18 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   52 (   3 ~  ;   0  |;  22  &)
%                                         (   4 <=>;  23 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   60 (   0 singleton;  56 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rf2_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf2_ x1 x2 -> rf2_ y1 y2 .
Variable rf1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf1_ x1 x2 -> rf1_ y1 y2 .
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable EqCongruence_ra_Px1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ra_Px1_ x1 x2 -> ra_Px1_ y1 y2 .
Variable cp2xcomp_ : Universe -> Prop.
Variable EqCongruence_cp2xcomp : forall x1 y1 : Universe, x1 = y1 -> cp2xcomp_ x1 -> cp2xcomp_ y1 .
Variable cp2_ : Universe -> Prop.
Variable EqCongruence_cp2 : forall x1 y1 : Universe, x1 = y1 -> cp2_ x1 -> cp2_ y1 .
Variable cp1_ : Universe -> Prop.
Variable EqCongruence_cp1 : forall x1 y1 : Universe, x1 = y1 -> cp1_ x1 -> cp1_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cSatisfiable_ : Universe -> Prop.
Variable EqCongruence_cSatisfiable : forall x1 y1 : Universe, x1 = y1 -> cSatisfiable_ x1 -> cSatisfiable_ y1 .

Variable i2003_11_14_17_16_21280_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable cp2xcomp_substitution_1_6 : (forall A B : Universe, ((A = B /\ cp2xcomp_ A) -> cp2xcomp_ B)).
Variable ra_Px1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rf1_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rf1_ A C) -> rf1_ B C)).
Variable rf1_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rf1_ C A) -> rf1_ C B)).
Variable rf2_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rf2_ A C) -> rf2_ B C)).
Variable rf2_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rf2_ C A) -> rf2_ C B)).
Variable rr_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_15 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_16 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_17 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_18 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_19 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rf2_ X Y /\ cp2_ Y)) /\ (exists Y : Universe, (rf1_ X Y /\ cp1_ Y))))).
Variable axiom_3_20 : (forall X : Universe, (cp1_ X -> cp2xcomp_ X)).
Variable axiom_4_21 : (forall X : Universe, (cp2_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_5_22 : (forall X : Universe, (cp2xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_6_23 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf1_ X Y0 /\ rf1_ X Y1) -> Y0 = Y1)))).
Variable axiom_7_24 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf2_ X Y0 /\ rf2_ X Y1) -> Y0 = Y1)))).
Variable axiom_8_25 : cSatisfiable_ i2003_11_14_17_16_21280_.
Variable axiom_9_26 : (forall X Y : Universe, (rr_ X Y -> rf1_ X Y)).
Variable axiom_10_27 : (forall X Y : Universe, (rr_ X Y -> rf2_ X Y)).

Theorem conjecture_28 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
