(*
% File     : KRS039+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t8.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest034 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    5 (   1 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   14 (   3 ~  ;   0  |;   4  &)
%                                         (   3 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   11 (   0 singleton;   9 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr1_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_15_58383_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ (forall Z : Universe, (rinvR_ Y Z -> (forall W : Universe, (rr1_ Z W -> cp_ W)))))) /\ (exists Y : Universe, (rr_ X Y /\ (forall Z : Universe, (rinvR_ Y Z -> (forall W : Universe, (rr1_ Z W -> ~(cp_ W)))))))))).
Variable axiom_3_4 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_4_5 : cSatisfiable_ i2003_11_14_17_15_58383_.

Theorem conjecture_6 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
