(*
% File     : KRS020+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : The union of two classes can be defined using OWL Lite 
% Version  : Especial.
% English  : The union of two classes can be defined using OWL Lite 
%            restrictions, and owl:intersectionOf.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_I5.2-Manifest005 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   29 (   0 equality)
%            Maximal formula depth :    5 (   5 average)
%            Number of connectives :   21 (   3 ~  ;   0  |;   5  &)
%                                         (   8 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   15 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   19 (   0 singleton;  14 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rq_ : Universe -> Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cnotB_ : Universe -> Prop.
Variable cnotAorB_ : Universe -> Prop.
Variable cnotA_ : Universe -> Prop.
Variable cNothing_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.
Variable cAorB_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.


Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cA_ X <-> (exists Y : Universe, (rq_ X Y /\ cowlThing_ Y)))).
Variable axiom_3_4 : (forall X : Universe, (cAorB_ X <-> (exists Y : Universe, (rs_ X Y /\ cowlThing_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (cB_ X <-> (exists Y : Universe, (rr_ X Y /\ cowlThing_ Y)))).
Variable axiom_5_6 : (forall X : Universe, (cNothing_ X -> ~((exists Y : Universe, rp_ X Y)))).
Variable axiom_6_7 : (forall X : Universe, (cNothing_ X -> (exists Y0 : Universe, rp_ X Y0))).
Variable axiom_7_8 : (forall X : Universe, (cnotA_ X <-> (forall Y : Universe, (rq_ X Y -> cNothing_ Y)))).
Variable axiom_8_9 : (forall X : Universe, (cnotAorB_ X <-> (forall Y : Universe, (rs_ X Y -> cNothing_ Y)))).
Variable axiom_9_10 : (forall X : Universe, (cnotAorB_ X <-> (cnotB_ X /\ cnotA_ X))).
Variable axiom_10_11 : (forall X : Universe, (cnotB_ X <-> (forall Y : Universe, (rr_ X Y -> cNothing_ Y)))).

Theorem conjecture_12 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
