(*
% File     : HAL002+1 : ILTP v1.1.2
% Domain   : Homological Algebra
% Problem  : Equivalence of injection axioms
% Version  : [TPTP] axioms.
% English  :
% Refs     : [Wei94] Weibel (1994), An Introduction to Homological Algebra
% Source   : [TPTP]
% Names    :
% Status   : Theorem
% Rating   : 0.64 v3.1.0, 0.67 v2.6.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   17 (   1 unit)
%            Number of atoms       :   79 (  20 equality)
%            Maximal formula depth :   16 (   9 average)
%            Number of connectives :   62 (   0 ~  ;   0  |;  34  &)
%                                         (   3 <=>;  25 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-4 arity)
%            Number of functors    :    6 (   3 constant; 0-3 arity)
%            Number of variables   :   77 (   0 singleton;  73 !;   4 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable surjection_ : Universe -> Prop.
Variable EqCongruence_surjection : forall x1 y1 : Universe, x1 = y1 -> surjection_ x1 -> surjection_ y1 .
Variable morphism_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_morphism : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> morphism_ x1 x2 x3 -> morphism_ y1 y2 y3 .
Variable injection_2_ : Universe -> Prop.
Variable EqCongruence_injection_2 : forall x1 y1 : Universe, x1 = y1 -> injection_2_ x1 -> injection_2_ y1 .
Variable injection_ : Universe -> Prop.
Variable EqCongruence_injection : forall x1 y1 : Universe, x1 = y1 -> injection_ x1 -> injection_ y1 .
Variable exact_ : Universe -> Universe -> Prop.
Variable EqCongruence_exact : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> exact_ x1 x2 -> exact_ y1 y2 .
Variable element_ : Universe -> Universe -> Prop.
Variable EqCongruence_element : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> element_ x1 x2 -> element_ y1 y2 .
Variable commute_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_commute : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> commute_ x1 x2 x3 x4 -> commute_ y1 y2 y3 y4 .

Variable zero_ : Universe -> Universe.
Variable EqCongruence_zero : forall x1 y1 : Universe, x1 = y1 -> zero_ x1 = zero_ y1 .
Variable x_ : Universe.
Variable subtract_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_subtract : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subtract_ x1 x2 x3 = subtract_ y1 y2 y3 .
Variable apply_ : Universe -> Universe -> Universe.
Variable EqCongruence_apply : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> apply_ x1 x2 = apply_ y1 y2 .
Variable any2_ : Universe.
Variable any1_ : Universe.

Variable morphism_1 : (forall Morphism Dom Cod : Universe, (morphism_ Morphism Dom Cod -> ((forall El : Universe, (element_ El Dom -> element_ (apply_ Morphism El) Cod)) /\ (apply_ Morphism (zero_ Dom)) = (zero_ Cod)))).
Variable injection_properties_2 : (forall Morphism Dom Cod : Universe, ((injection_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall El1 El2 : Universe, ((element_ El1 Dom /\ (element_ El2 Dom /\ (apply_ Morphism El1) = (apply_ Morphism El2))) -> El1 = El2)))).
Variable properties_for_injection_3 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall El1 El2 : Universe, ((element_ El1 Dom /\ (element_ El2 Dom /\ (apply_ Morphism El1) = (apply_ Morphism El2))) -> El1 = El2))) -> injection_ Morphism)).
Variable surjection_properties_4 : (forall Morphism Dom Cod : Universe, ((surjection_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall ElCod : Universe, (element_ ElCod Cod -> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism ElDom) = ElCod)))))).
Variable properties_for_surjection_5 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall ElCod : Universe, (element_ ElCod Cod -> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism ElDom) = ElCod))))) -> surjection_ Morphism)).
Variable exact_properties_6 : (forall Morphism1 Morphism2 Dom CodDom Cod : Universe, ((exact_ Morphism1 Morphism2 /\ (morphism_ Morphism1 Dom CodDom /\ morphism_ Morphism2 CodDom Cod)) -> (forall ElCodDom : Universe, ((element_ ElCodDom CodDom /\ (apply_ Morphism2 ElCodDom) = (zero_ Cod)) <-> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism1 ElDom) = ElCodDom)))))).
Variable properties_for_exact_7 : (forall Morphism1 Morphism2 Dom CodDom Cod : Universe, ((morphism_ Morphism1 Dom CodDom /\ (morphism_ Morphism2 CodDom Cod /\ (forall ElCodDom : Universe, ((element_ ElCodDom CodDom /\ (apply_ Morphism2 ElCodDom) = (zero_ Cod)) <-> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism1 ElDom) = ElCodDom)))))) -> exact_ Morphism1 Morphism2)).
Variable commute_properties_8 : (forall M1 M2 M3 M4 Dom DomCod1 DomCod2 Cod : Universe, ((commute_ M1 M2 M3 M4 /\ (morphism_ M1 Dom DomCod1 /\ (morphism_ M2 DomCod1 Cod /\ (morphism_ M3 Dom DomCod2 /\ morphism_ M4 DomCod2 Cod)))) -> (forall ElDom : Universe, (element_ ElDom Dom -> (apply_ M2 (apply_ M1 ElDom)) = (apply_ M4 (apply_ M3 ElDom)))))).
Variable properties_for_commute_9 : (forall M1 M2 M3 M4 Dom DomCod1 DomCod2 Cod : Universe, ((morphism_ M1 Dom DomCod1 /\ (morphism_ M2 DomCod1 Cod /\ (morphism_ M3 Dom DomCod2 /\ (morphism_ M4 DomCod2 Cod /\ (forall ElDom : Universe, (element_ ElDom Dom -> (apply_ M2 (apply_ M1 ElDom)) = (apply_ M4 (apply_ M3 ElDom)))))))) -> commute_ M1 M2 M3 M4)).
Variable subtract_in_domain_10 : (forall Dom El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> element_ (subtract_ Dom El1 El2) Dom)).
Variable subtract_to_0_11 : (forall Dom El : Universe, (element_ El Dom -> (subtract_ Dom El El) = (zero_ Dom))).
Variable subtract_cancellation_12 : (forall Dom El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> (subtract_ Dom El1 (subtract_ Dom El1 El2)) = El2)).
Variable subtract_distribution_13 : (forall Morphism Dom Cod : Universe, (morphism_ Morphism Dom Cod -> (forall El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> (apply_ Morphism (subtract_ Dom El1 El2)) = (subtract_ Cod (apply_ Morphism El1) (apply_ Morphism El2)))))).
Variable injection_properties_2_14 : (forall Morphism Dom Cod : Universe, ((injection_2_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall El : Universe, ((element_ El Dom /\ (apply_ Morphism El) = (zero_ Cod)) -> El = (zero_ Dom))))).
Variable properties_for_injection_2_15 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall El : Universe, ((element_ El Dom /\ (apply_ Morphism El) = (zero_ Cod)) -> El = (zero_ Dom)))) -> injection_2_ Morphism)).
Variable x_morphism_16 : morphism_ x_ any1_ any2_.

Set Firstorder Depth 10.

Theorem my_17 : (injection_ x_ <-> injection_2_ x_).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
