(*
% File     : GPJ003+1 : ILTP v1.1.2
% Domain   : Non-Clausal Group Theory
% Problem  : section 7, Exercise 8
% Version  : Especial.
% English  : 
% Refs     : [CL73] C.-L. Chang & R. C.-T. Lee. Symbolic Logic and Mechanical 
%                   Theorem Proving. New York, Academic Press, 1973.
%          : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
% Source   : [CL73]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.1.0
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable product_ : Universe -> Universe -> Universe -> Prop.

Variable inverse_ : Universe -> Universe.
Variable identity_ : Universe.
Variable a_ : Universe.

Variable ax1_1 : (forall X : Universe, product_ (inverse_ X) X identity_).
Variable ax2_2 : (forall X : Universe, product_ identity_ X X).
Variable ax3_3 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ U Z W)) -> product_ X V W)).
Variable ax4_4 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ X V W)) -> product_ U Z W)).

Set Firstorder Depth 10.

Theorem con_5 : product_ a_ identity_ a_.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
