(*
% File     : GPJ001+3 : ILTP v1.1.2
% Domain   : Non-Clausal Group Theory
% Problem  : Example 8.1 (commutativity)
% Version  : Especial.
% English  : If x*x=e for all x in group G, where * is a binary operator and
%            e is the identity in G, then G is commutative
% Refs     : [CL73] C.-L. Chang & R. C.-T. Lee. Symbolic Logic and Mechanical 
%                   Theorem Proving. New York, Academic Press, 1973.
% Source   : [CL73]
% Names    :
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Comments : Representation via equality theory
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.

Variable op_ : Universe -> Universe -> Universe.
Variable EqCongruence_op : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> op_ x1 x2 = op_ y1 y2 .
Variable inverse_ : Universe -> Universe.
Variable EqCongruence_inverse : forall x1 y1 : Universe, x1 = y1 -> inverse_ x1 = inverse_ y1 .
Variable identity_ : Universe.
Variable f_ : Universe -> Universe -> Universe.
Variable EqCongruence_f : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> f_ x1 x2 = f_ y1 y2 .

Variable ax1_1 : (forall X Y : Universe, (op_ X Y) = (f_ X Y)).
Variable ax2_2 : (forall X Y Z : Universe, (op_ X (op_ Y Z)) = (op_ (op_ X Y) Z)).
Variable ax3_3 : (forall X : Universe, (op_ X identity_) = X).
Variable ax4_4 : (forall X : Universe, (op_ identity_ X) = X).
Variable ax5_5 : (forall X : Universe, (op_ X (inverse_ X)) = identity_).
Variable ax6_6 : (forall X : Universe, (op_ (inverse_ X) X) = identity_).
Variable ax7_7 : (forall X : Universe, (op_ X X) = identity_).

Set Firstorder Depth 10.

Theorem con_8 : (forall X Y : Universe, (op_ X Y) = (op_ Y X)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
