(*
% File     : GPJ001+1 : ILTP v1.1.2
% Domain   : Non-Clausal Group Theory
% Problem  : Example 4.3 (Commutativity)
% Version  : Especial.
% English  : If x*x=e for all x in group G, where * is a binary operator and
%            e is the identity in G, then G is commutative
% Refs     : [CL73] C.-L. Chang & R. C.-T. Lee. Symbolic Logic and Mechanical 
%                   Theorem Proving. New York, Academic Press, 1973.
% Source   : [CL73]
% Names    :
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable product_ : Universe -> Universe -> Universe -> Prop.

Variable inverse_ : Universe -> Universe.
Variable identity_ : Universe.
Variable f_ : Universe -> Universe -> Universe.
Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.

Variable ax1_1 : (forall X Y : Universe, product_ X Y (f_ X Y)).
Variable ax2_2 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ U Z W)) -> product_ X V W)).
Variable ax3_3 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ X V W)) -> product_ U Z W)).
Variable ax4_4 : (forall X : Universe, product_ X identity_ X).
Variable ax5_5 : (forall X : Universe, product_ identity_ X X).
Variable ax6_6 : (forall X : Universe, product_ X (inverse_ X) identity_).
Variable ax7_7 : (forall X : Universe, product_ (inverse_ X) X identity_).
Variable ax8_8 : (forall X : Universe, product_ X X identity_).
Variable ax9_9 : product_ a_ b_ c_.

Set Firstorder Depth 10.

Theorem con_10 : product_ b_ a_ c_.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
