(*
% File     : GEO124+1 : ILTP v1.1.2
% Domain   : Geometry (Oriented curves)
% Problem  : Every oriented curve has at most one starting point
% Version  : [EHK99] axioms.
% English  :
% Refs     : [KE99]  Kulik & Eschenbach (1999), A Geometry of Oriented Curv
%          : [EHK99] Eschenbach et al. (1999), Representing Simple Trajecto
% Source   : [KE99]
% Names    : Corollary 4.10 (1) [KE99]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   28 (   2 unit)
%            Number of atoms       :  115 (  17 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   95 (   8 ~  ;  10  |;  39  &)
%                                         (  20 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   14 (   0 propositional; 1-4 arity)
%            Number of functors    :    2 (   0 constant; 1-2 arity)
%            Number of variables   :   97 (   0 singleton;  83 !;  14 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable start_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_start_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> start_point_ x1 x2 -> start_point_ y1 y2 .
Variable part_of_ : Universe -> Universe -> Prop.
Variable EqCongruence_part_of : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> part_of_ x1 x2 -> part_of_ y1 y2 .
Variable ordered_by_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_ordered_by : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> ordered_by_ x1 x2 x3 -> ordered_by_ y1 y2 y3 .
Variable open_ : Universe -> Prop.
Variable EqCongruence_open : forall x1 y1 : Universe, x1 = y1 -> open_ x1 -> open_ y1 .
Variable meet_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_meet : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> meet_ x1 x2 x3 -> meet_ y1 y2 y3 .
Variable inner_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_inner_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> inner_point_ x1 x2 -> inner_point_ y1 y2 .
Variable incident_o_ : Universe -> Universe -> Prop.
Variable EqCongruence_incident_o : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> incident_o_ x1 x2 -> incident_o_ y1 y2 .
Variable incident_c_ : Universe -> Universe -> Prop.
Variable EqCongruence_incident_c : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> incident_c_ x1 x2 -> incident_c_ y1 y2 .
Variable finish_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_finish_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> finish_point_ x1 x2 -> finish_point_ y1 y2 .
Variable end_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_end_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> end_point_ x1 x2 -> end_point_ y1 y2 .
Variable closed_ : Universe -> Prop.
Variable EqCongruence_closed : forall x1 y1 : Universe, x1 = y1 -> closed_ x1 -> closed_ y1 .
Variable between_o_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_between_o : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> between_o_ x1 x2 x3 x4 -> between_o_ y1 y2 y3 y4 .
Variable between_c_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_between_c : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> between_c_ x1 x2 x3 x4 -> between_c_ y1 y2 y3 y4 .

Variable underlying_curve_ : Universe -> Universe.
Variable EqCongruence_underlying_curve : forall x1 y1 : Universe, x1 = y1 -> underlying_curve_ x1 = underlying_curve_ y1 .
Variable sum_ : Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> sum_ x1 x2 = sum_ y1 y2 .

Variable part_of_defn_1 : (forall C C1 : Universe, (part_of_ C1 C <-> (forall P : Universe, (incident_c_ P C1 -> incident_c_ P C)))).
Variable sum_defn_2 : (forall C C1 C2 : Universe, (C = (sum_ C1 C2) <-> (forall Q : Universe, (incident_c_ Q C <-> (incident_c_ Q C1 \/ incident_c_ Q C2))))).
Variable end_point_defn_3 : (forall P C : Universe, (end_point_ P C <-> (incident_c_ P C /\ (forall C1 C2 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (incident_c_ P C1 /\ incident_c_ P C2))) -> (part_of_ C1 C2 \/ part_of_ C2 C1)))))).
Variable inner_point_defn_4 : (forall P C : Universe, (inner_point_ P C <-> (incident_c_ P C /\ ~(end_point_ P C)))).
Variable meet_defn_5 : (forall P C C1 : Universe, (meet_ P C C1 <-> (incident_c_ P C /\ (incident_c_ P C1 /\ (forall Q : Universe, ((incident_c_ Q C /\ incident_c_ Q C1) -> (end_point_ Q C /\ end_point_ Q C1))))))).
Variable closed_defn_6 : (forall C : Universe, (closed_ C <-> ~((exists P : Universe, end_point_ P C)))).
Variable open_defn_7 : (forall C : Universe, (open_ C <-> (exists P : Universe, end_point_ P C))).
Variable c1_8 : (forall C C1 : Universe, ((part_of_ C1 C /\ C1 <> C) -> open_ C1)).
Variable c2_9 : (forall C C1 C2 C3 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (part_of_ C3 C /\ (exists P : Universe, (end_point_ P C1 /\ (end_point_ P C2 /\ end_point_ P C3)))))) -> (part_of_ C2 C3 \/ (part_of_ C3 C2 \/ (part_of_ C1 C2 \/ (part_of_ C2 C1 \/ (part_of_ C1 C3 \/ part_of_ C3 C1))))))).
Variable c3_10 : (forall C : Universe, (exists P : Universe, inner_point_ P C)).
Variable c4_11 : (forall C P : Universe, (inner_point_ P C -> (exists C1 C2 : Universe, (meet_ P C1 C2 /\ C = (sum_ C1 C2))))).
Variable c5_12 : (forall C P Q R : Universe, ((end_point_ P C /\ (end_point_ Q C /\ end_point_ R C)) -> (P = Q \/ (P = R \/ Q = R)))).
Variable c6_13 : (forall C P : Universe, (end_point_ P C -> (exists Q : Universe, (end_point_ Q C /\ P <> Q)))).
Variable c7_14 : (forall C C1 C2 P : Universe, ((closed_ C /\ (meet_ P C1 C2 /\ C = (sum_ C1 C2))) -> (forall Q : Universe, (end_point_ Q C1 -> meet_ Q C1 C2)))).
Variable c8_15 : (forall C1 C2 : Universe, ((exists P : Universe, meet_ P C1 C2) -> (exists C : Universe, C = (sum_ C1 C2)))).
Variable c9_16 : (forall C C1 : Universe, ((forall P : Universe, (incident_c_ P C <-> incident_c_ P C1)) -> C = C1)).
Variable between_c_defn_17 : (forall C P Q R : Universe, (between_c_ C P Q R <-> (P <> R /\ (exists Cpp : Universe, (part_of_ Cpp C /\ (end_point_ P Cpp /\ (end_point_ R Cpp /\ inner_point_ Q Cpp))))))).
Variable between_o_defn_18 : (forall O P Q R : Universe, (between_o_ O P Q R <-> ((ordered_by_ O P Q /\ ordered_by_ O Q R) \/ (ordered_by_ O R Q /\ ordered_by_ O Q P)))).
Variable start_point_defn_19 : (forall P O : Universe, (start_point_ P O <-> (incident_o_ P O /\ (forall Q : Universe, ((P <> Q /\ incident_o_ Q O) -> ordered_by_ O P Q))))).
Variable finish_point_defn_20 : (forall P O : Universe, (finish_point_ P O <-> (incident_o_ P O /\ (forall Q : Universe, ((P <> Q /\ incident_o_ Q O) -> ordered_by_ O Q P))))).
Variable o1_21 : (forall O P Q : Universe, (ordered_by_ O P Q -> (incident_o_ P O /\ incident_o_ Q O))).
Variable o2_22 : (forall O : Universe, (exists C : Universe, (open_ C /\ (forall P : Universe, (incident_o_ P O <-> incident_c_ P C))))).
Variable o3_23 : (forall P Q R O : Universe, (between_o_ O P Q R <-> (exists C : Universe, ((forall P : Universe, (incident_o_ P O <-> incident_c_ P C)) /\ between_c_ C P Q R)))).
Variable o4_24 : (forall O : Universe, (exists P : Universe, start_point_ P O)).
Variable o5_25 : (forall P Q C : Universe, ((open_ C /\ (P <> Q /\ (incident_c_ P C /\ incident_c_ Q C))) -> (exists O : Universe, ((forall R : Universe, (incident_o_ R O <-> incident_c_ R C)) /\ ordered_by_ O P Q)))).
Variable o6_26 : (forall O1 O2 : Universe, ((forall P Q : Universe, (ordered_by_ O1 P Q <-> ordered_by_ O2 P Q)) -> O1 = O2)).
Variable underlying_curve_defn_27 : (forall C O : Universe, (C = (underlying_curve_ O) <-> (forall P : Universe, (incident_o_ P O <-> incident_c_ P C)))).

Set Firstorder Depth 10.

Theorem corollary_4_10_1_28 : (forall O P Q : Universe, ((start_point_ P O /\ start_point_ Q O) -> P = Q)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
