(*
% File     : GEO099+1 : ILTP v1.1.2
% Domain   : Geometry (Oriented curves)
% Problem  : Open subcurves can be complemented to form the sum
% Version  : [EHK99] axioms.
% English  : Every open sub-curve of a closed curve can be complemented by 
%            another curve so that their sum constitute the closed curve.
% Refs     : [KE99]  Kulik & Eschenbach (1999), A Geometry of Oriented Curv
%          : [EHK99] Eschenbach et al. (1999), Representing Simple Trajecto
% Source   : [KE99]
% Names    : Theorem 2.17 [KE99]
% Status   : Unsolved
% Rating   : 1.00 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   17 (   1 unit)
%            Number of atoms       :   75 (  12 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   63 (   5 ~  ;   9  |;  27  &)
%                                         (   9 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-3 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   58 (   0 singleton;  48 !;  10 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable part_of_ : Universe -> Universe -> Prop.
Variable EqCongruence_part_of : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> part_of_ x1 x2 -> part_of_ y1 y2 .
Variable open_ : Universe -> Prop.
Variable EqCongruence_open : forall x1 y1 : Universe, x1 = y1 -> open_ x1 -> open_ y1 .
Variable meet_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_meet : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> meet_ x1 x2 x3 -> meet_ y1 y2 y3 .
Variable inner_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_inner_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> inner_point_ x1 x2 -> inner_point_ y1 y2 .
Variable incident_c_ : Universe -> Universe -> Prop.
Variable EqCongruence_incident_c : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> incident_c_ x1 x2 -> incident_c_ y1 y2 .
Variable end_point_ : Universe -> Universe -> Prop.
Variable EqCongruence_end_point : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> end_point_ x1 x2 -> end_point_ y1 y2 .
Variable closed_ : Universe -> Prop.
Variable EqCongruence_closed : forall x1 y1 : Universe, x1 = y1 -> closed_ x1 -> closed_ y1 .

Variable sum_ : Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> sum_ x1 x2 = sum_ y1 y2 .

Variable part_of_defn_1 : (forall C C1 : Universe, (part_of_ C1 C <-> (forall P : Universe, (incident_c_ P C1 -> incident_c_ P C)))).
Variable sum_defn_2 : (forall C C1 C2 : Universe, (C = (sum_ C1 C2) <-> (forall Q : Universe, (incident_c_ Q C <-> (incident_c_ Q C1 \/ incident_c_ Q C2))))).
Variable end_point_defn_3 : (forall P C : Universe, (end_point_ P C <-> (incident_c_ P C /\ (forall C1 C2 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (incident_c_ P C1 /\ incident_c_ P C2))) -> (part_of_ C1 C2 \/ part_of_ C2 C1)))))).
Variable inner_point_defn_4 : (forall P C : Universe, (inner_point_ P C <-> (incident_c_ P C /\ ~(end_point_ P C)))).
Variable meet_defn_5 : (forall P C C1 : Universe, (meet_ P C C1 <-> (incident_c_ P C /\ (incident_c_ P C1 /\ (forall Q : Universe, ((incident_c_ Q C /\ incident_c_ Q C1) -> (end_point_ Q C /\ end_point_ Q C1))))))).
Variable closed_defn_6 : (forall C : Universe, (closed_ C <-> ~((exists P : Universe, end_point_ P C)))).
Variable open_defn_7 : (forall C : Universe, (open_ C <-> (exists P : Universe, end_point_ P C))).
Variable c1_8 : (forall C C1 : Universe, ((part_of_ C1 C /\ C1 <> C) -> open_ C1)).
Variable c2_9 : (forall C C1 C2 C3 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (part_of_ C3 C /\ (exists P : Universe, (end_point_ P C1 /\ (end_point_ P C2 /\ end_point_ P C3)))))) -> (part_of_ C2 C3 \/ (part_of_ C3 C2 \/ (part_of_ C1 C2 \/ (part_of_ C2 C1 \/ (part_of_ C1 C3 \/ part_of_ C3 C1))))))).
Variable c3_10 : (forall C : Universe, (exists P : Universe, inner_point_ P C)).
Variable c4_11 : (forall C P : Universe, (inner_point_ P C -> (exists C1 C2 : Universe, (meet_ P C1 C2 /\ C = (sum_ C1 C2))))).
Variable c5_12 : (forall C P Q R : Universe, ((end_point_ P C /\ (end_point_ Q C /\ end_point_ R C)) -> (P = Q \/ (P = R \/ Q = R)))).
Variable c6_13 : (forall C P : Universe, (end_point_ P C -> (exists Q : Universe, (end_point_ Q C /\ P <> Q)))).
Variable c7_14 : (forall C C1 C2 P : Universe, ((closed_ C /\ (meet_ P C1 C2 /\ C = (sum_ C1 C2))) -> (forall Q : Universe, (end_point_ Q C1 -> meet_ Q C1 C2)))).
Variable c8_15 : (forall C1 C2 : Universe, ((exists P : Universe, meet_ P C1 C2) -> (exists C : Universe, C = (sum_ C1 C2)))).
Variable c9_16 : (forall C C1 : Universe, ((forall P : Universe, (incident_c_ P C <-> incident_c_ P C1)) -> C = C1)).

Set Firstorder Depth 10.

Theorem theorem_2_17_17 : (forall C C1 P Q : Universe, ((closed_ C /\ (part_of_ C1 C /\ (end_point_ P C1 /\ (end_point_ Q C1 /\ P <> Q)))) -> (exists C2 : Universe, (meet_ P C1 C2 /\ (meet_ Q C1 C2 /\ C = (sum_ C1 C2)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
