(*
% File     : GEJ069+1 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Therorem 5.2 (Ordered Geometry)
% Version  : [P98] axioms.
% English  : 
% Refs     : [P98] J. von Plato. A Constructive Theory of Ordered Affine
%                  Geometry. Indagationes Mathematicae, vol. 9: 549-562, 
%                  1998.
% Source   : [P98]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : 
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable undir_ : Universe -> Universe -> Prop.
Variable point_ : Universe -> Prop.
Variable line_ : Universe -> Prop.
Variable lcon_ : Universe -> Universe -> Prop.
Variable lapt_ : Universe -> Universe -> Prop.
Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable rev_ : Universe -> Universe.
Variable pt_ : Universe -> Universe -> Universe.
Variable par_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable ax1_1 : (forall A : Universe, ~(dipt_ A A)).
Variable ax2_2 : (forall A B C : Universe, (dipt_ A B -> (dipt_ A C \/ dipt_ B C))).
Variable ax3_3 : (forall L : Universe, ~(diln_ L L)).
Variable ax4_4 : (forall L M N : Universe, (diln_ L M -> (diln_ L N \/ diln_ M N))).
Variable ax5_5 : (forall L : Universe, ~(undir_ L L)).
Variable ax6_6 : (forall L M N : Universe, (undir_ L M -> (undir_ L N \/ undir_ M N))).
Variable ax7_7 : (forall L M N : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> ((undir_ L N /\ undir_ L (rev_ N)) \/ (undir_ M N /\ undir_ M (rev_ N))))).
Variable ax8_8 : (forall L M : Universe, (undir_ L M \/ undir_ L (rev_ M))).
Variable ax9_9 : (forall L M : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> (lcon_ L M \/ lcon_ L (rev_ M)))).
Variable ax10_10 : (forall A L : Universe, ~((lapt_ A L \/ lapt_ A (rev_ L)))).
Variable ax11_11 : (forall L M : Universe, ~((lcon_ L M \/ lcon_ L (rev_ M)))).
Variable ax1_12 : (forall A B : Universe, ((point_ A /\ (point_ B /\ dipt_ A B)) -> line_ (ln_ A B))).
Variable ax2_13 : (forall L M : Universe, ((line_ L /\ (line_ M /\ (undir_ L M /\ undir_ L (rev_ M)))) -> point_ (pt_ L M))).
Variable ax3_14 : (forall L A : Universe, ((point_ A /\ line_ L) -> line_ (par_ L A))).
Variable ax4_15 : (forall L : Universe, (line_ L -> line_ (rev_ L))).
Variable ax5_16 : (forall A B : Universe, (dipt_ A B -> (~(apt_ A (ln_ A B)) /\ ~(apt_ B (ln_ A B))))).
Variable ax6_17 : (forall L M : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> (~(apt_ (pt_ L M) L) /\ ~(apt_ (pt_ L M) M)))).
Variable ax7_18 : (forall A L : Universe, ~(apt_ A (par_ L A))).
Variable ax8_19 : (forall L : Universe, ~(diln_ L (rev_ L))).
Variable ax9_20 : (forall A B : Universe, ~(undir_ (ln_ A B) (rev_ (ln_ B A)))).
Variable ax10_21 : (forall A L : Universe, ~(undir_ (par_ L A) L)).
Variable ax1_22 : (forall A B L M : Universe, ((dipt_ A B /\ diln_ L M) -> (lapt_ A L \/ (lapt_ B L \/ (lapt_ A M \/ (lapt_ B M \/ (lapt_ A (rev_ L) \/ (lapt_ B (rev_ L) \/ (lapt_ A (rev_ M) \/ lapt_ B (rev_ M)))))))))).
Variable ax2_23 : (forall A B L : Universe, ((dipt_ A B /\ lapt_ A L) -> (lapt_ B L \/ lcon_ (ln_ A B) L))).
Variable ax1_24 : (forall A B L : Universe, (lapt_ A L -> (dipt_ A B \/ lapt_ B L))).
Variable ax2_25 : (forall A L M : Universe, ((lapt_ A L /\ undir_ L M) -> (diln_ L M \/ lapt_ A (rev_ M)))).
Variable ax3_26 : (forall L M N : Universe, (lcon_ L M -> (undir_ M N \/ lcon_ L N))).

Set Firstorder Depth 10.

Theorem con_27 : (forall A L M : Universe, ((lapt_ A L /\ lapt_ A (rev_ M)) -> (undir_ L M \/ diln_ L M))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
