(*
% File     : GEJ055+2 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Problem 9.1.
% Version  : [D97],[D98] axioms : Especial.
% English  : Assume orthogonal geometry. Given a point and a line, to find 
%          : a point incident with the line.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
% Source   : [P95]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : 
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable unort_ : Universe -> Universe -> Prop.
Variable point_ : Universe -> Prop.
Variable line_ : Universe -> Prop.
Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable par_ : Universe -> Universe -> Universe.
Variable ort_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y Z : Universe, (dipt_ X Y -> (apt_ Z (ln_ X Y) -> (dipt_ Z X /\ dipt_ Z Y)))).
Variable a2_8 : (forall X Y Z : Universe, (con_ X Y -> ((apt_ Z X \/ apt_ Z Y) -> dipt_ Z (pt_ X Y)))).
Variable a1_9 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).
Variable a1_10 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_11 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_12 : (forall X Y : Universe, (con_ X Y -> diln_ X Y)).
Variable a1_13 : (forall X Y : Universe, ~(con_ (par_ Y X) Y)).
Variable a2_14 : (forall X Y : Universe, ~(apt_ X (par_ Y X))).
Variable a1_15 : (forall X Y Z : Universe, (diln_ Y Z -> ((apt_ X Y \/ apt_ X Z) \/ con_ Y Z))).
Variable a1_16 : (forall L M : Universe, (con_ L M \/ unort_ L M)).
Variable a1_17 : (forall L M N : Universe, ((con_ L M /\ unort_ L M) -> ((con_ L N /\ unort_ L N) \/ (con_ M N /\ unort_ M N)))).
Variable a1_18 : (forall A L : Universe, ~(unort_ (ort_ L A) L)).
Variable a2_19 : (forall A L : Universe, ~(apt_ A (ort_ L A))).
Variable a1_20 : (forall A L M N : Universe, (diln_ L M -> ((apt_ A L \/ apt_ A M) \/ (unort_ L N \/ unort_ M N)))).
Variable a1_21 : (forall A B : Universe, ((point_ A /\ (point_ B /\ dipt_ A B)) -> line_ (ln_ A B))).
Variable a1_22 : (forall L M : Universe, ((line_ L /\ (line_ M /\ con_ L M)) -> point_ (pt_ L M))).
Variable a1_23 : (forall L A : Universe, ((line_ L /\ point_ A) -> line_ (ort_ L A))).

Set Firstorder Depth 10.

Theorem con_24 : (forall X Y : Universe, ((point_ X /\ line_ Y) -> (exists Z : Universe, (point_ Z /\ ~(apt_ Z Y))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
