(*
% File     : GEJ041+1 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 8.1
% Version  : [P95] axioms.
% English  : If the point A is incident with line L, and the line L is
%          : orthogonal to M, then L is equal to the orthogonal to M 
%          : through A.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
% Source   : [P95]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : 
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable unort_ : Universe -> Universe -> Prop.
Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable par_ : Universe -> Universe -> Universe.
Variable ort_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ X (ln_ X Y)))).
Variable a2_8 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ Y (ln_ X Y)))).
Variable a3_9 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) X))).
Variable a4_10 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) Y))).
Variable a1_11 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).
Variable a1_12 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_13 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_14 : (forall X Y Z : Universe, (con_ X Y -> (diln_ Y Z \/ con_ X Z))).
Variable a1_15 : (forall X Y : Universe, ~(con_ (par_ Y X) Y)).
Variable a2_16 : (forall X Y : Universe, ~(apt_ X (par_ Y X))).
Variable a1_17 : (forall X Y Z : Universe, (diln_ Y Z -> ((apt_ X Y \/ apt_ X Z) \/ con_ Y Z))).
Variable a1_18 : (forall L M : Universe, (con_ L M \/ unort_ L M)).
Variable a1_19 : (forall L M N : Universe, ((con_ L M /\ unort_ L M) -> ((con_ L N /\ unort_ L N) \/ (con_ M N /\ unort_ M N)))).
Variable a1_20 : (forall A L : Universe, ~(unort_ (ort_ L A) L)).
Variable a2_21 : (forall A L : Universe, ~(apt_ A (ort_ L A))).
Variable a1_22 : (forall A L M N : Universe, (diln_ L M -> ((apt_ A L \/ apt_ A M) \/ (unort_ L N \/ unort_ M N)))).

Set Firstorder Depth 10.

Theorem con_23 : (forall A L M : Universe, ((~(apt_ A L) /\ ~(unort_ L M)) -> ~(diln_ L (ort_ M A)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
