(*
% File     : GEJ035+2 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 5.5
% Version  : [D97],[D98] axioms : Especial.
% English  : If the points X and Y are distinct, and the points Y and Z are
%          : equal, then X and Z are distinct, and the line connecting X 
%          : and Y is equivalent to the line connecting X and Z.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
% Source   : [P95]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Comments : Shortened axioms
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y Z : Universe, (dipt_ X Y -> (apt_ Z (ln_ X Y) -> (dipt_ Z X /\ dipt_ Z Y)))).
Variable a2_8 : (forall X Y Z : Universe, (con_ X Y -> ((apt_ Z X \/ apt_ Z Y) -> dipt_ Z (pt_ X Y)))).
Variable a1_9 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).
Variable a1_10 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_11 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_12 : (forall X Y : Universe, (con_ X Y -> diln_ X Y)).

Set Firstorder Depth 10.

Theorem con_13 : (forall X Y Z : Universe, ((dipt_ X Y /\ ~(dipt_ Y Z)) -> (dipt_ X Z /\ ~(diln_ (ln_ X Y) (ln_ X Z))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
