(*
% File     : GEJ027+1 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 4.11
% Version  : [P95] axioms.
% English  : If the lines X and Y are convergent, U and V are convergent,
%          : and the intersection point of X and Y is incident with U and V,
%          : then the intersection point of U and V is incident with X and Y.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
% Source   : [P95]
% Names    :
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ X (ln_ X Y)))).
Variable a2_8 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ Y (ln_ X Y)))).
Variable a3_9 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) X))).
Variable a4_10 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) Y))).
Variable a1_11 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).
Variable a1_12 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_13 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_14 : (forall X Y Z : Universe, (con_ X Y -> (diln_ Y Z \/ con_ X Z))).

Set Firstorder Depth 10.

Theorem con_15 : (forall X Y U V : Universe, ((con_ X Y /\ (con_ U V /\ (~(apt_ (pt_ X Y) U) /\ ~(apt_ (pt_ X Y) V)))) -> (~(apt_ (pt_ U V) X) /\ ~(apt_ (pt_ U V) Y)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
