(*
% File     : GEJ010+3 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Lemma 4.3.ii (Theorems 4: symmetry in apartness and incidence)
% Version  : [T96] axioms : Especial.
% English  : If two points X and Y are distinct and a point Z is apart from
%          : the line connecting X and Y, then the line connecting X and Y
%          : is distinct from the line connecting Z and X and distinct from
%          : the line connecting Z and Y.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
%          : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
% Source   : [T96]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.1.0
% Comments : Reduced axioms
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ X (ln_ X Y)))).
Variable a2_2 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ Y (ln_ X Y)))).
Variable a3_3 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) X))).
Variable a4_4 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) Y))).
Variable a1_5 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_6 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_7 : (forall X Y Z : Universe, (con_ X Y -> (diln_ Y Z \/ con_ X Z))).

Set Firstorder Depth 10.

Theorem con_8 : (forall X Y Z : Universe, ((dipt_ X Y /\ apt_ Z (ln_ X Y)) -> (diln_ (ln_ X Y) (ln_ Z X) /\ diln_ (ln_ X Y) (ln_ Z Y)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
