(*
% File     : GEJ008+3 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 4.2 (Symmetry of Apartness)
% Version  : [T96] axioms : Especial.
% English  : If the points X and Y are distinct and U and V are distinct,
%          : and X or Y is apart from the line connecting U and V, then
%          : U or V are apart from the line connecting X and Y.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
%          : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
% Source   : [T96]
% Names    :
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Comments : Reduced axioms, using lemma 4.1.i.r and 4.1.i.l
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y U V : Universe, ((dipt_ X Y /\ (con_ U V /\ dipt_ X (pt_ U V))) -> (apt_ X U \/ apt_ X V))).
Variable a2_8 : (forall X Y U V : Universe, ((dipt_ X Y /\ (con_ U V /\ (apt_ X U \/ apt_ X V))) -> dipt_ X (pt_ U V))).

Set Firstorder Depth 10.

Theorem con_9 : (forall X Y U V : Universe, ((dipt_ X Y /\ dipt_ U V) -> ((apt_ X (ln_ U V) \/ apt_ Y (ln_ U V)) -> (apt_ U (ln_ X Y) \/ apt_ V (ln_ X Y))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
