(*
% File     : GEJ004+4 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Lemma 4.1.i.r (Theorems 4: symmetry in apartness and incidence)
% Version  : [D97],[D98],[T96] axioms : Especial.
% English  : If two points are distinct and a line U is distinct from the
%          : line connecting the points, then U is apart from at least one
%          : of these points.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
%          : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
% Source   : [T96]
% Names    :
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Comments : Shortened and Reduced axioms
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X Y Z : Universe, (dipt_ X Y -> (apt_ Z (ln_ X Y) -> (dipt_ Z X /\ dipt_ Z Y)))).
Variable a2_2 : (forall X Y Z : Universe, (con_ X Y -> ((apt_ Z X \/ apt_ Z Y) -> dipt_ Z (pt_ X Y)))).
Variable a1_3 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).

Set Firstorder Depth 10.

Theorem con_4 : (forall X Y U V : Universe, ((dipt_ X Y /\ (con_ U V /\ diln_ U (ln_ X Y))) -> (apt_ X U \/ apt_ Y U))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
