(*
% File     : CSR019+1 : ILTP v1.1.2
% Domain   : Commonsense Reasoning
% Problem  : Not forwards at time 2
% Version  : [Mue04] axioms : Especial.
% English  :
% Refs     : [MS05]  Mueller & Sutcliffe (2005), Reasoning in the Event Cal
%          : [Mue04] Mueller (2004), A Tool for Satisfiability-based Common
%          : [MS02]  Miller & Shanahan (2002), Some Alternative Formulation
% Source   : [MS05]
% Names    :
% Status   : Theorem
% Rating   : 0.36 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   48 (  22 unit)
%            Number of atoms       :  138 (  43 equality)
%            Maximal formula depth :   13 (   4 average)
%            Number of connectives :  123 (  33 ~  ;  13  |;  51  &)
%                                         (  16 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 2-4 arity)
%            Number of functors    :   16 (  15 constant; 0-2 arity)
%            Number of variables   :   73 (   0 singleton;  64 !;   9 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable trajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_trajectory : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> trajectory_ x1 x2 x3 x4 -> trajectory_ y1 y2 y3 y4 .
Variable terminates_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_terminates : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> terminates_ x1 x2 x3 -> terminates_ y1 y2 y3 .
Variable stoppedIn_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_stoppedIn : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> stoppedIn_ x1 x2 x3 -> stoppedIn_ y1 y2 y3 .
Variable startedIn_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_startedIn : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> startedIn_ x1 x2 x3 -> startedIn_ y1 y2 y3 .
Variable releases_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_releases : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> releases_ x1 x2 x3 -> releases_ y1 y2 y3 .
Variable releasedAt_ : Universe -> Universe -> Prop.
Variable EqCongruence_releasedAt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> releasedAt_ x1 x2 -> releasedAt_ y1 y2 .
Variable less_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_less_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_or_equal_ x1 x2 -> less_or_equal_ y1 y2 .
Variable less_ : Universe -> Universe -> Prop.
Variable EqCongruence_less : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_ x1 x2 -> less_ y1 y2 .
Variable initiates_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_initiates : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> initiates_ x1 x2 x3 -> initiates_ y1 y2 y3 .
Variable holdsAt_ : Universe -> Universe -> Prop.
Variable EqCongruence_holdsAt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> holdsAt_ x1 x2 -> holdsAt_ y1 y2 .
Variable happens_ : Universe -> Universe -> Prop.
Variable EqCongruence_happens : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> happens_ x1 x2 -> happens_ y1 y2 .
Variable antitrajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_antitrajectory : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> antitrajectory_ x1 x2 x3 x4 -> antitrajectory_ y1 y2 y3 y4 .

Variable spinning_ : Universe.
Variable push_ : Universe.
Variable pull_ : Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable EqCongruence_plus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> plus_ x1 x2 = plus_ y1 y2 .
Variable n9_ : Universe.
Variable n8_ : Universe.
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable forwards_ : Universe.
Variable backwards_ : Universe.

Variable stoppedin_defn_1 : (forall Time1 Fluent Time2 : Universe, (stoppedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ terminates_ Event Fluent Time)))))).
Variable startedin_defn_2 : (forall Time1 Time2 Fluent : Universe, (startedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ initiates_ Event Fluent Time)))))).
Variable change_holding_3 : (forall Event Time Fluent Fluent2 Offset : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time /\ (less_ n0_ Offset /\ (trajectory_ Fluent Time Fluent2 Offset /\ ~(stoppedIn_ Time Fluent (plus_ Time Offset)))))) -> holdsAt_ Fluent2 (plus_ Time Offset))).
Variable antitrajectory_4 : (forall Event Time1 Fluent1 Time2 Fluent2 : Universe, ((happens_ Event Time1 /\ (terminates_ Event Fluent1 Time1 /\ (less_ n0_ Time2 /\ (antitrajectory_ Fluent1 Time1 Fluent2 Time2 /\ ~(startedIn_ Time1 Fluent1 (plus_ Time1 Time2)))))) -> holdsAt_ Fluent2 (plus_ Time1 Time2))).
Variable keep_holding_5 : (forall Fluent Time : Universe, ((holdsAt_ Fluent Time /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ terminates_ Event Fluent Time))))) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable keep_not_holding_6 : (forall Fluent Time : Universe, ((~(holdsAt_ Fluent Time) /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ initiates_ Event Fluent Time))))) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable keep_released_7 : (forall Fluent Time : Universe, ((releasedAt_ Fluent Time /\ ~((exists Event : Universe, (happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time))))) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable keep_not_released_8 : (forall Fluent Time : Universe, ((~(releasedAt_ Fluent Time) /\ ~((exists Event : Universe, (happens_ Event Time /\ releases_ Event Fluent Time)))) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable happens_holds_9 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ initiates_ Event Fluent Time) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable happens_terminates_not_holds_10 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ terminates_ Event Fluent Time) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable happens_releases_11 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ releases_ Event Fluent Time) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable happens_not_released_12 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time)) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable initiates_all_defn_13 : (forall Event Fluent Time : Universe, (initiates_ Event Fluent Time <-> ((Event = push_ /\ (Fluent = forwards_ /\ ~(happens_ pull_ Time))) \/ ((Event = pull_ /\ (Fluent = backwards_ /\ ~(happens_ push_ Time))) \/ (Event = pull_ /\ (Fluent = spinning_ /\ happens_ push_ Time)))))).
Variable terminates_all_defn_14 : (forall Event Fluent Time : Universe, (terminates_ Event Fluent Time <-> ((Event = push_ /\ (Fluent = backwards_ /\ ~(happens_ pull_ Time))) \/ ((Event = pull_ /\ (Fluent = forwards_ /\ ~(happens_ push_ Time))) \/ ((Event = pull_ /\ (Fluent = forwards_ /\ happens_ push_ Time)) \/ ((Event = pull_ /\ (Fluent = backwards_ /\ happens_ push_ Time)) \/ ((Event = push_ /\ (Fluent = spinning_ /\ ~(happens_ pull_ Time))) \/ (Event = pull_ /\ (Fluent = spinning_ /\ ~(happens_ push_ Time)))))))))).
Variable releases_all_defn_15 : (forall Event Fluent Time : Universe, ~(releases_ Event Fluent Time)).
Variable happens_all_defn_16 : (forall Event Time : Universe, (happens_ Event Time <-> ((Event = push_ /\ Time = n0_) \/ ((Event = pull_ /\ Time = n1_) \/ ((Event = pull_ /\ Time = n2_) \/ (Event = push_ /\ Time = n2_)))))).
Variable push_not_pull_17 : push_ <> pull_.
Variable forwards_not_backwards_18 : forwards_ <> backwards_.
Variable forwards_not_spinning_19 : forwards_ <> spinning_.
Variable spinning_not_backwards_20 : spinning_ <> backwards_.
Variable plus0_0_21 : (plus_ n0_ n0_) = n0_.
Variable plus0_1_22 : (plus_ n0_ n1_) = n1_.
Variable plus0_2_23 : (plus_ n0_ n2_) = n2_.
Variable plus0_3_24 : (plus_ n0_ n3_) = n3_.
Variable plus1_1_25 : (plus_ n1_ n1_) = n2_.
Variable plus1_2_26 : (plus_ n1_ n2_) = n3_.
Variable plus1_3_27 : (plus_ n1_ n3_) = n4_.
Variable plus2_2_28 : (plus_ n2_ n2_) = n4_.
Variable plus2_3_29 : (plus_ n2_ n3_) = n5_.
Variable plus3_3_30 : (plus_ n3_ n3_) = n6_.
Variable symmetry_of_plus_31 : (forall X Y : Universe, (plus_ X Y) = (plus_ Y X)).
Variable less_or_equal_32 : (forall X Y : Universe, (less_or_equal_ X Y <-> (less_ X Y \/ X = Y))).
Variable less0_33 : ~((exists X : Universe, less_ X n0_)).
Variable less1_34 : (forall X : Universe, (less_ X n1_ <-> less_or_equal_ X n0_)).
Variable less2_35 : (forall X : Universe, (less_ X n2_ <-> less_or_equal_ X n1_)).
Variable less3_36 : (forall X : Universe, (less_ X n3_ <-> less_or_equal_ X n2_)).
Variable less4_37 : (forall X : Universe, (less_ X n4_ <-> less_or_equal_ X n3_)).
Variable less5_38 : (forall X : Universe, (less_ X n5_ <-> less_or_equal_ X n4_)).
Variable less6_39 : (forall X : Universe, (less_ X n6_ <-> less_or_equal_ X n5_)).
Variable less7_40 : (forall X : Universe, (less_ X n7_ <-> less_or_equal_ X n6_)).
Variable less8_41 : (forall X : Universe, (less_ X n8_ <-> less_or_equal_ X n7_)).
Variable less9_42 : (forall X : Universe, (less_ X n9_ <-> less_or_equal_ X n8_)).
Variable less_property_43 : (forall X Y : Universe, (less_ X Y <-> (~(less_ Y X) /\ Y <> X))).
Variable not_forwards_0_44 : ~(holdsAt_ forwards_ n0_).
Variable not_backwards_0_45 : ~(holdsAt_ backwards_ n0_).
Variable not_splinning_0_46 : ~(holdsAt_ spinning_ n0_).
Variable not_releasedAt_47 : (forall Fluent Time : Universe, ~(releasedAt_ Fluent Time)).

Set Firstorder Depth 10.

Theorem not_forwards_2_48 : ~(holdsAt_ forwards_ n2_).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
