(*
% File     : CSR001+1 : ILTP v1.1.2
% Domain   : Commonsense Reasoning
% Problem  : Water level is 3 at time 4
% Version  : [Mue04] axioms : Especial.
% English  :
% Refs     : [MS05]  Mueller & Sutcliffe (2005), Reasoning in the Event Cal
%          : [Mue04] Mueller (2004), A Tool for Satisfiability-based Common
%          : [MS02]  Miller & Shanahan (2002), Some Alternative Formulation
% Source   : [MS05]
% Names    :
% Status   : Theorem
% Rating   : 0.82 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   55 (  25 unit)
%            Number of atoms       :  136 (  40 equality)
%            Maximal formula depth :   12 (   4 average)
%            Number of connectives :  109 (  28 ~  ;   8  |;  43  &)
%                                         (  18 <=>;  12 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 2-4 arity)
%            Number of functors    :   17 (  15 constant; 0-2 arity)
%            Number of variables   :   86 (   0 singleton;  74 !;  12 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable trajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_trajectory : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> trajectory_ x1 x2 x3 x4 -> trajectory_ y1 y2 y3 y4 .
Variable terminates_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_terminates : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> terminates_ x1 x2 x3 -> terminates_ y1 y2 y3 .
Variable stoppedIn_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_stoppedIn : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> stoppedIn_ x1 x2 x3 -> stoppedIn_ y1 y2 y3 .
Variable startedIn_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_startedIn : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> startedIn_ x1 x2 x3 -> startedIn_ y1 y2 y3 .
Variable releases_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_releases : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> releases_ x1 x2 x3 -> releases_ y1 y2 y3 .
Variable releasedAt_ : Universe -> Universe -> Prop.
Variable EqCongruence_releasedAt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> releasedAt_ x1 x2 -> releasedAt_ y1 y2 .
Variable less_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_less_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_or_equal_ x1 x2 -> less_or_equal_ y1 y2 .
Variable less_ : Universe -> Universe -> Prop.
Variable EqCongruence_less : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_ x1 x2 -> less_ y1 y2 .
Variable initiates_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_initiates : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> initiates_ x1 x2 x3 -> initiates_ y1 y2 y3 .
Variable holdsAt_ : Universe -> Universe -> Prop.
Variable EqCongruence_holdsAt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> holdsAt_ x1 x2 -> holdsAt_ y1 y2 .
Variable happens_ : Universe -> Universe -> Prop.
Variable EqCongruence_happens : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> happens_ x1 x2 -> happens_ y1 y2 .
Variable antitrajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_antitrajectory : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> antitrajectory_ x1 x2 x3 x4 -> antitrajectory_ y1 y2 y3 y4 .

Variable waterLevel_ : Universe -> Universe.
Variable EqCongruence_waterLevel : forall x1 y1 : Universe, x1 = y1 -> waterLevel_ x1 = waterLevel_ y1 .
Variable tapOn_ : Universe.
Variable tapOff_ : Universe.
Variable spilling_ : Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable EqCongruence_plus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> plus_ x1 x2 = plus_ y1 y2 .
Variable overflow_ : Universe.
Variable n9_ : Universe.
Variable n8_ : Universe.
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable filling_ : Universe.

Variable stoppedin_defn_1 : (forall Time1 Fluent Time2 : Universe, (stoppedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ terminates_ Event Fluent Time)))))).
Variable startedin_defn_2 : (forall Time1 Time2 Fluent : Universe, (startedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ initiates_ Event Fluent Time)))))).
Variable change_holding_3 : (forall Event Time Fluent Fluent2 Offset : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time /\ (less_ n0_ Offset /\ (trajectory_ Fluent Time Fluent2 Offset /\ ~(stoppedIn_ Time Fluent (plus_ Time Offset)))))) -> holdsAt_ Fluent2 (plus_ Time Offset))).
Variable antitrajectory_4 : (forall Event Time1 Fluent1 Time2 Fluent2 : Universe, ((happens_ Event Time1 /\ (terminates_ Event Fluent1 Time1 /\ (less_ n0_ Time2 /\ (antitrajectory_ Fluent1 Time1 Fluent2 Time2 /\ ~(startedIn_ Time1 Fluent1 (plus_ Time1 Time2)))))) -> holdsAt_ Fluent2 (plus_ Time1 Time2))).
Variable keep_holding_5 : (forall Fluent Time : Universe, ((holdsAt_ Fluent Time /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ terminates_ Event Fluent Time))))) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable keep_not_holding_6 : (forall Fluent Time : Universe, ((~(holdsAt_ Fluent Time) /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ initiates_ Event Fluent Time))))) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable keep_released_7 : (forall Fluent Time : Universe, ((releasedAt_ Fluent Time /\ ~((exists Event : Universe, (happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time))))) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable keep_not_released_8 : (forall Fluent Time : Universe, ((~(releasedAt_ Fluent Time) /\ ~((exists Event : Universe, (happens_ Event Time /\ releases_ Event Fluent Time)))) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable happens_holds_9 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ initiates_ Event Fluent Time) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable happens_terminates_not_holds_10 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ terminates_ Event Fluent Time) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable happens_releases_11 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ releases_ Event Fluent Time) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable happens_not_released_12 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time)) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable initiates_all_defn_13 : (forall Event Fluent Time : Universe, (initiates_ Event Fluent Time <-> ((Event = tapOn_ /\ Fluent = filling_) \/ ((Event = overflow_ /\ Fluent = spilling_) \/ ((exists Height : Universe, (holdsAt_ (waterLevel_ Height) Time /\ (Event = tapOff_ /\ Fluent = (waterLevel_ Height)))) \/ (exists Height : Universe, (holdsAt_ (waterLevel_ Height) Time /\ (Event = overflow_ /\ Fluent = (waterLevel_ Height))))))))).
Variable terminates_all_defn_14 : (forall Event Fluent Time : Universe, (terminates_ Event Fluent Time <-> ((Event = tapOff_ /\ Fluent = filling_) \/ (Event = overflow_ /\ Fluent = filling_)))).
Variable releases_all_defn_15 : (forall Event Fluent Time : Universe, (releases_ Event Fluent Time <-> (exists Height : Universe, (Event = tapOn_ /\ Fluent = (waterLevel_ Height))))).
Variable happens_all_defn_16 : (forall Event Time : Universe, (happens_ Event Time <-> ((Event = tapOn_ /\ Time = n0_) \/ (holdsAt_ (waterLevel_ n3_) Time /\ (holdsAt_ filling_ Time /\ Event = overflow_))))).
Variable change_of_waterLevel_17 : (forall Height1 Time Height2 Offset : Universe, ((holdsAt_ (waterLevel_ Height1) Time /\ Height2 = (plus_ Height1 Offset)) -> trajectory_ filling_ Time (waterLevel_ Height2) Offset)).
Variable same_waterLevel_18 : (forall Time Height1 Height2 : Universe, ((holdsAt_ (waterLevel_ Height1) Time /\ holdsAt_ (waterLevel_ Height2) Time) -> Height1 = Height2)).
Variable tapOff_not_tapOn_19 : tapOff_ <> tapOn_.
Variable tapOff_not_overflow_20 : tapOff_ <> overflow_.
Variable overflow_not_tapOn_21 : overflow_ <> tapOn_.
Variable filling_not_waterLevel_22 : (forall X : Universe, filling_ <> (waterLevel_ X)).
Variable spilling_not_waterLevel_23 : (forall X : Universe, spilling_ <> (waterLevel_ X)).
Variable filling_not_spilling_24 : filling_ <> spilling_.
Variable distinct_waterLevels_25 : (forall X Y : Universe, ((waterLevel_ X) = (waterLevel_ Y) <-> X = Y)).
Variable plus0_0_26 : (plus_ n0_ n0_) = n0_.
Variable plus0_1_27 : (plus_ n0_ n1_) = n1_.
Variable plus0_2_28 : (plus_ n0_ n2_) = n2_.
Variable plus0_3_29 : (plus_ n0_ n3_) = n3_.
Variable plus1_1_30 : (plus_ n1_ n1_) = n2_.
Variable plus1_2_31 : (plus_ n1_ n2_) = n3_.
Variable plus1_3_32 : (plus_ n1_ n3_) = n4_.
Variable plus2_2_33 : (plus_ n2_ n2_) = n4_.
Variable plus2_3_34 : (plus_ n2_ n3_) = n5_.
Variable plus3_3_35 : (plus_ n3_ n3_) = n6_.
Variable symmetry_of_plus_36 : (forall X Y : Universe, (plus_ X Y) = (plus_ Y X)).
Variable less_or_equal_37 : (forall X Y : Universe, (less_or_equal_ X Y <-> (less_ X Y \/ X = Y))).
Variable less0_38 : ~((exists X : Universe, less_ X n0_)).
Variable less1_39 : (forall X : Universe, (less_ X n1_ <-> less_or_equal_ X n0_)).
Variable less2_40 : (forall X : Universe, (less_ X n2_ <-> less_or_equal_ X n1_)).
Variable less3_41 : (forall X : Universe, (less_ X n3_ <-> less_or_equal_ X n2_)).
Variable less4_42 : (forall X : Universe, (less_ X n4_ <-> less_or_equal_ X n3_)).
Variable less5_43 : (forall X : Universe, (less_ X n5_ <-> less_or_equal_ X n4_)).
Variable less6_44 : (forall X : Universe, (less_ X n6_ <-> less_or_equal_ X n5_)).
Variable less7_45 : (forall X : Universe, (less_ X n7_ <-> less_or_equal_ X n6_)).
Variable less8_46 : (forall X : Universe, (less_ X n8_ <-> less_or_equal_ X n7_)).
Variable less9_47 : (forall X : Universe, (less_ X n9_ <-> less_or_equal_ X n8_)).
Variable less_property_48 : (forall X Y : Universe, (less_ X Y <-> (~(less_ Y X) /\ Y <> X))).
Variable waterLevel_0_49 : holdsAt_ (waterLevel_ n0_) n0_.
Variable not_filling_0_50 : ~(holdsAt_ filling_ n0_).
Variable not_spilling_0_51 : ~(holdsAt_ spilling_ n0_).
Variable not_released_waterLevel_0_52 : (forall Height : Universe, ~(releasedAt_ (waterLevel_ Height) n0_)).
Variable not_released_filling_0_53 : ~(releasedAt_ filling_ n0_).
Variable not_released_spilling_0_54 : ~(releasedAt_ spilling_ n0_).

Set Firstorder Depth 10.

Theorem waterLevel_4_55 : holdsAt_ (waterLevel_ n3_) n4_.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
