(*
% File     : ALG210+1 : ILTP v1.1.2
% Domain   : General Algebra
% Problem  : Star-algebras are closed under multiplication
% Version  : Especial.
% English  : 
% Refs     : [Col04] Colton (2004), Email to G.Sutcliffe
% Source   : [Col04]
% Names    : 
% Status   : Theorem
% Rating   : 0.45 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    3 (   1 unit)
%            Number of atoms       :    7 (   3 equality)
%            Maximal formula depth :    5 (   5 average)
%            Number of connectives :    4 (   0 ~  ;   0  |;   2  &)
%                                         (   1 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :    7 (   0 singleton;   6 !;   1 ?)
%            Maximal term depth    :    3 (   2 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable element_ : Universe -> Prop.
Variable EqCongruence_element : forall x1 y1 : Universe, x1 = y1 -> element_ x1 -> element_ y1 .

Variable times_ : Universe -> Universe -> Universe.
Variable EqCongruence_times : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> times_ x1 x2 = times_ y1 y2 .

Variable axiom_1_1 : (forall A B C : Universe, (times_ (times_ A B) C) = (times_ B (times_ C A))).
Variable axiom_2_2 : (forall B : Universe, (element_ B <-> (exists C : Universe, ((times_ B C) = B /\ (times_ B B) = C)))).

Set Firstorder Depth 10.

Theorem conjecture_1_3 : (forall A B : Universe, ((element_ A /\ element_ B) -> element_ (times_ A B))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
