(*
% File     : AGT026+1 : ILTP v1.1.2
% Domain   : Agents
% Problem  : Problem for the CPlanT system
% Version  : [Bar03] axioms : Especial.
% English  :
% Refs     : [Bar03] Barta, J. (2003), Email to G. Sutcliffe
%          : [BT+03] Barta et al. (2003), Meta-Reasoning in CPlanT Multi-Ag
%          : [TBP03] Tozicka et al. (2003), Meta-reasoning for Agents' Priv
% Source   : [Bar03]
% Names    :
% Status   : Theorem
% Rating   : 0.82 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :  556 ( 524 unit)
%            Number of atoms       :  656 (   2 equality)
%            Maximal formula depth :    8 (   1 average)
%            Number of connectives :  144 (  44 ~  ;   1  |;  67  &)
%                                         (  16 <=>;  16 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   0 propositional; 1-4 arity)
%            Number of functors    :  290 ( 286 constant; 0-2 arity)
%            Number of variables   :   72 (   0 singleton;  70 !;   2 ?)
%            Maximal term depth    :    5 (   1 average)
% Comments :
% Bugfixes : v3.0.0 - Bugfix in NUM005+0.ax
%          : v3.0.0 - Bugfixes in NUM005+1.ax
%          : v3.1.0 - Changes to NUM005 axioms
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable the_agent_not_in_any_proposed_teams_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_the_agent_not_in_any_proposed_teams : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> the_agent_not_in_any_proposed_teams_ x1 x2 x3 -> the_agent_not_in_any_proposed_teams_ y1 y2 y3 .
Variable the_agent_in_all_proposed_teams_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_the_agent_in_all_proposed_teams : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> the_agent_in_all_proposed_teams_ x1 x2 x3 -> the_agent_in_all_proposed_teams_ y1 y2 y3 .
Variable sum_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_sum : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> sum_ x1 x2 x3 -> sum_ y1 y2 y3 .
Variable rdn_translate_ : Universe -> Universe -> Prop.
Variable EqCongruence_rdn_translate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rdn_translate_ x1 x2 -> rdn_translate_ y1 y2 .
Variable rdn_positive_less_ : Universe -> Universe -> Prop.
Variable EqCongruence_rdn_positive_less : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rdn_positive_less_ x1 x2 -> rdn_positive_less_ y1 y2 .
Variable rdn_non_zero_digit_ : Universe -> Prop.
Variable EqCongruence_rdn_non_zero_digit : forall x1 y1 : Universe, x1 = y1 -> rdn_non_zero_digit_ x1 -> rdn_non_zero_digit_ y1 .
Variable rdn_non_zero_ : Universe -> Prop.
Variable EqCongruence_rdn_non_zero : forall x1 y1 : Universe, x1 = y1 -> rdn_non_zero_ x1 -> rdn_non_zero_ y1 .
Variable min_number_of_proposed_agents_ : Universe -> Universe -> Prop.
Variable EqCongruence_min_number_of_proposed_agents : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> min_number_of_proposed_agents_ x1 x2 -> min_number_of_proposed_agents_ y1 y2 .
Variable less_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_less_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_or_equal_ x1 x2 -> less_or_equal_ y1 y2 .
Variable less_ : Universe -> Universe -> Prop.
Variable EqCongruence_less : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> less_ x1 x2 -> less_ y1 y2 .
Variable any_agent_in_all_proposed_teams_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_any_agent_in_all_proposed_teams : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> any_agent_in_all_proposed_teams_ x1 x2 x3 -> any_agent_in_all_proposed_teams_ y1 y2 y3 .
Variable accept_team_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_accept_team : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> accept_team_ x1 x2 x3 x4 -> accept_team_ y1 y2 y3 y4 .
Variable accept_population_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_accept_population : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> accept_population_ x1 x2 x3 -> accept_population_ y1 y2 y3 .
Variable accept_number_ : Universe -> Universe -> Prop.
Variable EqCongruence_accept_number : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> accept_number_ x1 x2 -> accept_number_ y1 y2 .
Variable accept_leader_ : Universe -> Universe -> Prop.
Variable EqCongruence_accept_leader : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> accept_leader_ x1 x2 -> accept_leader_ y1 y2 .
Variable accept_city_ : Universe -> Universe -> Prop.
Variable EqCongruence_accept_city : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> accept_city_ x1 x2 -> accept_city_ y1 y2 .

Variable townc_ : Universe.
Variable townb_ : Universe.
Variable towna_ : Universe.
Variable sunsetpoint_ : Universe.
Variable sunnysideport_ : Universe.
Variable suffertown_ : Universe.
Variable sufferterragovernment_ : Universe.
Variable stjosephburgh_ : Universe.
Variable rdnn_ : Universe -> Universe.
Variable EqCongruence_rdnn : forall x1 y1 : Universe, x1 = y1 -> rdnn_ x1 = rdnn_ y1 .
Variable rdn_pos_ : Universe -> Universe.
Variable EqCongruence_rdn_pos : forall x1 y1 : Universe, x1 = y1 -> rdn_pos_ x1 = rdn_pos_ y1 .
Variable rdn_neg_ : Universe -> Universe.
Variable EqCongruence_rdn_neg : forall x1 y1 : Universe, x1 = y1 -> rdn_neg_ x1 = rdn_neg_ y1 .
Variable rdn_ : Universe -> Universe -> Universe.
Variable EqCongruence_rdn : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rdn_ x1 x2 = rdn_ y1 y2 .
Variable other_ : Universe.
Variable northport_ : Universe.
Variable nn99_ : Universe.
Variable nn98_ : Universe.
Variable nn97_ : Universe.
Variable nn96_ : Universe.
Variable nn95_ : Universe.
Variable nn94_ : Universe.
Variable nn93_ : Universe.
Variable nn92_ : Universe.
Variable nn91_ : Universe.
Variable nn90_ : Universe.
Variable nn9_ : Universe.
Variable nn89_ : Universe.
Variable nn88_ : Universe.
Variable nn87_ : Universe.
Variable nn86_ : Universe.
Variable nn85_ : Universe.
Variable nn84_ : Universe.
Variable nn83_ : Universe.
Variable nn82_ : Universe.
Variable nn81_ : Universe.
Variable nn80_ : Universe.
Variable nn8_ : Universe.
Variable nn79_ : Universe.
Variable nn78_ : Universe.
Variable nn77_ : Universe.
Variable nn76_ : Universe.
Variable nn75_ : Universe.
Variable nn74_ : Universe.
Variable nn73_ : Universe.
Variable nn72_ : Universe.
Variable nn71_ : Universe.
Variable nn70_ : Universe.
Variable nn7_ : Universe.
Variable nn69_ : Universe.
Variable nn68_ : Universe.
Variable nn67_ : Universe.
Variable nn66_ : Universe.
Variable nn65_ : Universe.
Variable nn64_ : Universe.
Variable nn63_ : Universe.
Variable nn62_ : Universe.
Variable nn61_ : Universe.
Variable nn60_ : Universe.
Variable nn6_ : Universe.
Variable nn59_ : Universe.
Variable nn58_ : Universe.
Variable nn57_ : Universe.
Variable nn56_ : Universe.
Variable nn55_ : Universe.
Variable nn54_ : Universe.
Variable nn53_ : Universe.
Variable nn52_ : Universe.
Variable nn51_ : Universe.
Variable nn50_ : Universe.
Variable nn5_ : Universe.
Variable nn49_ : Universe.
Variable nn48_ : Universe.
Variable nn47_ : Universe.
Variable nn46_ : Universe.
Variable nn45_ : Universe.
Variable nn44_ : Universe.
Variable nn43_ : Universe.
Variable nn42_ : Universe.
Variable nn41_ : Universe.
Variable nn40_ : Universe.
Variable nn4_ : Universe.
Variable nn39_ : Universe.
Variable nn38_ : Universe.
Variable nn37_ : Universe.
Variable nn36_ : Universe.
Variable nn35_ : Universe.
Variable nn34_ : Universe.
Variable nn33_ : Universe.
Variable nn32_ : Universe.
Variable nn31_ : Universe.
Variable nn30_ : Universe.
Variable nn3_ : Universe.
Variable nn29_ : Universe.
Variable nn28_ : Universe.
Variable nn27_ : Universe.
Variable nn26_ : Universe.
Variable nn25_ : Universe.
Variable nn24_ : Universe.
Variable nn23_ : Universe.
Variable nn22_ : Universe.
Variable nn21_ : Universe.
Variable nn20_ : Universe.
Variable nn2_ : Universe.
Variable nn19_ : Universe.
Variable nn18_ : Universe.
Variable nn17_ : Universe.
Variable nn16_ : Universe.
Variable nn15_ : Universe.
Variable nn14_ : Universe.
Variable nn13_ : Universe.
Variable nn128_ : Universe.
Variable nn127_ : Universe.
Variable nn126_ : Universe.
Variable nn125_ : Universe.
Variable nn124_ : Universe.
Variable nn123_ : Universe.
Variable nn122_ : Universe.
Variable nn121_ : Universe.
Variable nn120_ : Universe.
Variable nn12_ : Universe.
Variable nn119_ : Universe.
Variable nn118_ : Universe.
Variable nn117_ : Universe.
Variable nn116_ : Universe.
Variable nn115_ : Universe.
Variable nn114_ : Universe.
Variable nn113_ : Universe.
Variable nn112_ : Universe.
Variable nn111_ : Universe.
Variable nn110_ : Universe.
Variable nn11_ : Universe.
Variable nn109_ : Universe.
Variable nn108_ : Universe.
Variable nn107_ : Universe.
Variable nn106_ : Universe.
Variable nn105_ : Universe.
Variable nn104_ : Universe.
Variable nn103_ : Universe.
Variable nn102_ : Universe.
Variable nn101_ : Universe.
Variable nn100_ : Universe.
Variable nn10_ : Universe.
Variable nn1_ : Universe.
Variable native_ : Universe.
Variable n99_ : Universe.
Variable n98_ : Universe.
Variable n97_ : Universe.
Variable n96_ : Universe.
Variable n95_ : Universe.
Variable n94_ : Universe.
Variable n93_ : Universe.
Variable n92_ : Universe.
Variable n91_ : Universe.
Variable n90_ : Universe.
Variable n9_ : Universe.
Variable n89_ : Universe.
Variable n88_ : Universe.
Variable n87_ : Universe.
Variable n86_ : Universe.
Variable n85_ : Universe.
Variable n84_ : Universe.
Variable n83_ : Universe.
Variable n82_ : Universe.
Variable n81_ : Universe.
Variable n80_ : Universe.
Variable n8_ : Universe.
Variable n79_ : Universe.
Variable n78_ : Universe.
Variable n77_ : Universe.
Variable n76_ : Universe.
Variable n75_ : Universe.
Variable n74_ : Universe.
Variable n73_ : Universe.
Variable n72_ : Universe.
Variable n71_ : Universe.
Variable n70_ : Universe.
Variable n7_ : Universe.
Variable n69_ : Universe.
Variable n68_ : Universe.
Variable n67_ : Universe.
Variable n66_ : Universe.
Variable n65_ : Universe.
Variable n64_ : Universe.
Variable n63_ : Universe.
Variable n62_ : Universe.
Variable n61_ : Universe.
Variable n60_ : Universe.
Variable n6_ : Universe.
Variable n59_ : Universe.
Variable n58_ : Universe.
Variable n57_ : Universe.
Variable n56_ : Universe.
Variable n55_ : Universe.
Variable n54_ : Universe.
Variable n53_ : Universe.
Variable n52_ : Universe.
Variable n51_ : Universe.
Variable n50_ : Universe.
Variable n5_ : Universe.
Variable n49_ : Universe.
Variable n48_ : Universe.
Variable n47_ : Universe.
Variable n46_ : Universe.
Variable n45_ : Universe.
Variable n44_ : Universe.
Variable n43_ : Universe.
Variable n42_ : Universe.
Variable n41_ : Universe.
Variable n40_ : Universe.
Variable n4_ : Universe.
Variable n39_ : Universe.
Variable n38_ : Universe.
Variable n37_ : Universe.
Variable n36_ : Universe.
Variable n35_ : Universe.
Variable n34_ : Universe.
Variable n33_ : Universe.
Variable n32_ : Universe.
Variable n31_ : Universe.
Variable n30_ : Universe.
Variable n3_ : Universe.
Variable n29_ : Universe.
Variable n28_ : Universe.
Variable n27_ : Universe.
Variable n26_ : Universe.
Variable n25_ : Universe.
Variable n24_ : Universe.
Variable n23_ : Universe.
Variable n22_ : Universe.
Variable n21_ : Universe.
Variable n20_ : Universe.
Variable n2_ : Universe.
Variable n19_ : Universe.
Variable n18_ : Universe.
Variable n17_ : Universe.
Variable n16_ : Universe.
Variable n15_ : Universe.
Variable n14_ : Universe.
Variable n13_ : Universe.
Variable n127_ : Universe.
Variable n126_ : Universe.
Variable n125_ : Universe.
Variable n124_ : Universe.
Variable n123_ : Universe.
Variable n122_ : Universe.
Variable n121_ : Universe.
Variable n120_ : Universe.
Variable n12_ : Universe.
Variable n119_ : Universe.
Variable n118_ : Universe.
Variable n117_ : Universe.
Variable n116_ : Universe.
Variable n115_ : Universe.
Variable n114_ : Universe.
Variable n113_ : Universe.
Variable n112_ : Universe.
Variable n111_ : Universe.
Variable n110_ : Universe.
Variable n11_ : Universe.
Variable n109_ : Universe.
Variable n108_ : Universe.
Variable n107_ : Universe.
Variable n106_ : Universe.
Variable n105_ : Universe.
Variable n104_ : Universe.
Variable n103_ : Universe.
Variable n102_ : Universe.
Variable n101_ : Universe.
Variable n100_ : Universe.
Variable n10_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable muslimcountrybhumanitarianorganization_ : Universe.
Variable muslim_ : Universe.
Variable countrycmedicalorganization_ : Universe.
Variable countryccivilorganization_ : Universe.
Variable countrybhumanitarianorganization_ : Universe.
Variable countrybcivilorganization_ : Universe.
Variable countryamedicalorganization_ : Universe.
Variable countryahumanitarianorganization_ : Universe.
Variable countryafirstaidorganization_ : Universe.
Variable countryacivilorganization_ : Universe.
Variable coastvillage_ : Universe.
Variable cityb_ : Universe.
Variable citya_ : Universe.
Variable christiansufferterrahumanitarianorganization_ : Universe.
Variable christiancountrychumanitarianorganization_ : Universe.
Variable christian_ : Universe.
Variable centraltown_ : Universe.
Variable centrallakecity_ : Universe.
Variable atheist_ : Universe.

Variable a1_1_1 : (forall A C N L : Universe, (accept_team_ A L C N <-> (accept_city_ A C /\ (accept_leader_ A L /\ accept_number_ A N)))).
Variable a1_2_2 : (forall A N M : Universe, ((accept_number_ A N /\ less_ M N) -> accept_number_ A M)).
Variable a1_3_3 : (forall A N M P : Universe, ((accept_population_ A P N /\ less_ M N) -> accept_population_ A P M)).
Variable a1_4_4 : (forall A L C : Universe, (the_agent_in_all_proposed_teams_ A L C -> (accept_leader_ A L /\ accept_city_ A C))).
Variable a1_5_5 : (forall A L C : Universe, (any_agent_in_all_proposed_teams_ A L C -> accept_leader_ A L)).
Variable a1_6_6 : (forall A L C : Universe, (the_agent_not_in_any_proposed_teams_ A L C -> ~((accept_city_ A C /\ accept_leader_ A L)))).
Variable a1_7_7 : (forall A N : Universe, (min_number_of_proposed_agents_ A N -> accept_number_ A N)).
Variable a2_1_8 : (forall A : Universe, ((accept_population_ A atheist_ n65_ /\ (accept_population_ A christian_ n20_ /\ (accept_population_ A muslim_ n7_ /\ (accept_population_ A native_ n4_ /\ accept_population_ A other_ n4_)))) <-> accept_city_ A suffertown_)).
Variable a2_2_9 : (forall A : Universe, ((accept_population_ A atheist_ n54_ /\ (accept_population_ A christian_ n23_ /\ (accept_population_ A muslim_ n3_ /\ (accept_population_ A native_ n1_ /\ accept_population_ A other_ n9_)))) <-> accept_city_ A centraltown_)).
Variable a2_3_10 : (forall A : Universe, ((accept_population_ A atheist_ n30_ /\ (accept_population_ A christian_ n8_ /\ (accept_population_ A muslim_ n60_ /\ (accept_population_ A native_ n1_ /\ accept_population_ A other_ n1_)))) <-> accept_city_ A sunnysideport_)).
Variable a2_4_11 : (forall A : Universe, ((accept_population_ A atheist_ n70_ /\ (accept_population_ A christian_ n15_ /\ (accept_population_ A muslim_ n1_ /\ (accept_population_ A native_ n10_ /\ accept_population_ A other_ n4_)))) <-> accept_city_ A centrallakecity_)).
Variable a2_5_12 : (forall A : Universe, ((accept_population_ A atheist_ n68_ /\ (accept_population_ A christian_ n16_ /\ (accept_population_ A muslim_ n1_ /\ (accept_population_ A native_ n11_ /\ accept_population_ A other_ n4_)))) <-> accept_city_ A stjosephburgh_)).
Variable a2_6_13 : (forall A : Universe, ((accept_population_ A atheist_ n70_ /\ (accept_population_ A christian_ n13_ /\ (accept_population_ A muslim_ n0_ /\ (accept_population_ A native_ n15_ /\ accept_population_ A other_ n2_)))) <-> accept_city_ A northport_)).
Variable a2_7_14 : (forall A : Universe, ((accept_population_ A atheist_ n12_ /\ (accept_population_ A christian_ n3_ /\ (accept_population_ A muslim_ n0_ /\ (accept_population_ A native_ n85_ /\ accept_population_ A other_ n0_)))) <-> accept_city_ A coastvillage_)).
Variable a2_8_15 : (forall A : Universe, ((accept_population_ A atheist_ n0_ /\ (accept_population_ A christian_ n0_ /\ (accept_population_ A muslim_ n0_ /\ (accept_population_ A native_ n100_ /\ accept_population_ A other_ n0_)))) <-> accept_city_ A sunsetpoint_)).
Variable a2_9_16 : (forall A : Universe, ((accept_population_ A atheist_ n75_ /\ (accept_population_ A christian_ n24_ /\ (accept_population_ A muslim_ n1_ /\ (accept_population_ A native_ n0_ /\ accept_population_ A other_ n0_)))) <-> accept_city_ A towna_)).
Variable a2_10_17 : (forall A : Universe, ((accept_population_ A atheist_ n75_ /\ (accept_population_ A christian_ n25_ /\ (accept_population_ A muslim_ n0_ /\ (accept_population_ A native_ n0_ /\ accept_population_ A other_ n0_)))) <-> accept_city_ A citya_)).
Variable a2_11_18 : (forall A : Universe, ((accept_population_ A atheist_ n70_ /\ (accept_population_ A christian_ n20_ /\ (accept_population_ A muslim_ n8_ /\ (accept_population_ A native_ n0_ /\ accept_population_ A other_ n2_)))) <-> accept_city_ A townb_)).
Variable a2_12_19 : (forall A : Universe, ((accept_population_ A atheist_ n78_ /\ (accept_population_ A christian_ n20_ /\ (accept_population_ A muslim_ n1_ /\ (accept_population_ A native_ n0_ /\ accept_population_ A other_ n1_)))) <-> accept_city_ A cityb_)).
Variable a2_13_20 : (forall A : Universe, ((accept_population_ A atheist_ n30_ /\ (accept_population_ A christian_ n0_ /\ (accept_population_ A muslim_ n65_ /\ (accept_population_ A native_ n0_ /\ accept_population_ A other_ n5_)))) <-> accept_city_ A townc_)).
Variable event_1_21 : accept_team_ countryahumanitarianorganization_ countryacivilorganization_ cityb_ n6_.
Variable event_2_22 : accept_team_ countryahumanitarianorganization_ countryacivilorganization_ towna_ n6_.
Variable event_3_23 : accept_team_ countryahumanitarianorganization_ countryacivilorganization_ coastvillage_ n6_.
Variable event_4_24 : accept_team_ countryahumanitarianorganization_ countryafirstaidorganization_ coastvillage_ n6_.
Variable event_5_25 : the_agent_in_all_proposed_teams_ countryahumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_6_26 : any_agent_in_all_proposed_teams_ countryahumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_7_27 : accept_team_ countryccivilorganization_ countrybhumanitarianorganization_ cityb_ n2_.
Variable event_8_28 : accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n4_.
Variable event_9_29 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n4_).
Variable event_10_30 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n5_).
Variable event_11_31 : the_agent_not_in_any_proposed_teams_ muslimcountrybhumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_12_32 : any_agent_in_all_proposed_teams_ muslimcountrybhumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_13_33 : accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_ n5_.
Variable event_14_34 : accept_team_ countryamedicalorganization_ countryacivilorganization_ cityb_ n6_.
Variable event_15_35 : accept_team_ christiancountrychumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n4_.
Variable event_16_36 : accept_team_ countryafirstaidorganization_ countryacivilorganization_ cityb_ n6_.
Variable event_17_37 : accept_number_ countrybhumanitarianorganization_ n4_.
Variable event_18_38 : accept_team_ countrybcivilorganization_ countrybhumanitarianorganization_ cityb_ n4_.
Variable event_19_39 : accept_team_ christiansufferterrahumanitarianorganization_ countryacivilorganization_ cityb_ n6_.
Variable event_20_40 : accept_team_ sufferterragovernment_ countryacivilorganization_ cityb_ n6_.
Variable event_21_41 : accept_number_ countrybhumanitarianorganization_ n1_.
Variable event_22_42 : the_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_23_43 : any_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_24_44 : accept_team_ countrybhumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_ n5_.
Variable event_25_45 : accept_team_ countrybhumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_ n6_.
Variable event_26_46 : accept_team_ christiansufferterrahumanitarianorganization_ countryacivilorganization_ towna_ n6_.
Variable event_27_47 : accept_team_ countryamedicalorganization_ countryacivilorganization_ towna_ n6_.
Variable event_28_48 : accept_number_ countryahumanitarianorganization_ n2_.
Variable event_29_49 : ~(accept_team_ countryamedicalorganization_ countryahumanitarianorganization_ coastvillage_ n2_).
Variable event_30_50 : ~(accept_team_ countryamedicalorganization_ countryafirstaidorganization_ coastvillage_ n2_).
Variable event_31_51 : ~(accept_team_ countryamedicalorganization_ countryacivilorganization_ coastvillage_ n2_).
Variable event_32_52 : ~(accept_team_ countryamedicalorganization_ christiansufferterrahumanitarianorganization_ coastvillage_ n2_).
Variable event_33_53 : ~(accept_team_ countryamedicalorganization_ sufferterragovernment_ coastvillage_ n2_).
Variable event_34_54 : ~(accept_team_ countryamedicalorganization_ countryahumanitarianorganization_ coastvillage_ n6_).
Variable event_35_55 : ~(accept_team_ countryamedicalorganization_ countryacivilorganization_ coastvillage_ n6_).
Variable event_36_56 : ~(accept_team_ countryamedicalorganization_ countryafirstaidorganization_ coastvillage_ n6_).
Variable event_37_57 : the_agent_not_in_any_proposed_teams_ countryamedicalorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_38_58 : any_agent_in_all_proposed_teams_ countryamedicalorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_39_59 : accept_team_ countryccivilorganization_ countrycmedicalorganization_ towna_ n4_.
Variable event_40_60 : ~(accept_team_ countryccivilorganization_ countrycmedicalorganization_ towna_ n5_).
Variable event_41_61 : the_agent_in_all_proposed_teams_ countryccivilorganization_ countryacivilorganization_ towna_.
Variable event_42_62 : any_agent_in_all_proposed_teams_ countryccivilorganization_ countryacivilorganization_ towna_.
Variable event_43_63 : accept_team_ countrybcivilorganization_ countrycmedicalorganization_ towna_ n4_.
Variable event_44_64 : accept_team_ countrybcivilorganization_ countrycmedicalorganization_ towna_ n5_.
Variable event_45_65 : accept_number_ countrybcivilorganization_ n5_.
Variable event_46_66 : the_agent_in_all_proposed_teams_ countrybcivilorganization_ countryacivilorganization_ towna_.
Variable event_47_67 : any_agent_in_all_proposed_teams_ countrybcivilorganization_ countryacivilorganization_ towna_.
Variable event_48_68 : accept_team_ sufferterragovernment_ countryacivilorganization_ towna_ n6_.
Variable event_49_69 : the_agent_in_all_proposed_teams_ countrycmedicalorganization_ countryacivilorganization_ towna_.
Variable event_50_70 : any_agent_in_all_proposed_teams_ countrycmedicalorganization_ countryacivilorganization_ towna_.
Variable event_51_71 : accept_team_ countrycmedicalorganization_ christiancountrychumanitarianorganization_ coastvillage_ n5_.
Variable event_52_72 : accept_number_ countrycmedicalorganization_ n4_.
Variable event_53_73 : accept_team_ christiancountrychumanitarianorganization_ countrycmedicalorganization_ towna_ n4_.
Variable event_54_74 : accept_number_ countrycmedicalorganization_ n5_.
Variable event_55_75 : accept_team_ christiancountrychumanitarianorganization_ countrycmedicalorganization_ towna_ n5_.
Variable event_56_76 : the_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_57_77 : any_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ countryacivilorganization_ towna_.
Variable event_58_78 : accept_team_ countryafirstaidorganization_ countryacivilorganization_ towna_ n6_.
Variable event_59_79 : accept_number_ countryacivilorganization_ n2_.
Variable event_60_80 : accept_team_ countryacivilorganization_ countryahumanitarianorganization_ coastvillage_ n5_.
Variable event_61_81 : accept_team_ countryacivilorganization_ countryahumanitarianorganization_ coastvillage_ n6_.
Variable event_62_82 : accept_team_ countryacivilorganization_ countryafirstaidorganization_ coastvillage_ n6_.
Variable event_63_83 : the_agent_in_all_proposed_teams_ countryacivilorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_64_84 : any_agent_in_all_proposed_teams_ countryacivilorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_65_85 : accept_number_ countryafirstaidorganization_ n2_.
Variable event_66_86 : accept_team_ countryafirstaidorganization_ countryahumanitarianorganization_ coastvillage_ n5_.
Variable event_67_87 : accept_team_ countryafirstaidorganization_ countryahumanitarianorganization_ coastvillage_ n6_.
Variable event_68_88 : accept_team_ countryafirstaidorganization_ countryacivilorganization_ coastvillage_ n6_.
Variable event_69_89 : the_agent_in_all_proposed_teams_ countryafirstaidorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_70_90 : any_agent_in_all_proposed_teams_ countryafirstaidorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_71_91 : ~(accept_team_ countryccivilorganization_ christiancountrychumanitarianorganization_ coastvillage_ n5_).
Variable event_72_92 : ~(accept_team_ countryccivilorganization_ christiancountrychumanitarianorganization_ coastvillage_ n6_).
Variable event_73_93 : accept_number_ christiancountrychumanitarianorganization_ n5_.
Variable event_74_94 : accept_team_ countrybcivilorganization_ christiancountrychumanitarianorganization_ coastvillage_ n5_.
Variable event_75_95 : accept_team_ countrybcivilorganization_ christiancountrychumanitarianorganization_ coastvillage_ n6_.
Variable event_76_96 : accept_team_ countrybcivilorganization_ muslimcountrybhumanitarianorganization_ townc_ n6_.
Variable event_77_97 : accept_team_ countrybcivilorganization_ countrybhumanitarianorganization_ townc_ n6_.
Variable event_78_98 : accept_team_ countrybcivilorganization_ christiancountrychumanitarianorganization_ townc_ n6_.
Variable event_79_99 : accept_team_ countrybcivilorganization_ countrycmedicalorganization_ townc_ n6_.
Variable event_80_100 : the_agent_in_all_proposed_teams_ countrybcivilorganization_ countryahumanitarianorganization_ townc_.
Variable event_81_101 : any_agent_in_all_proposed_teams_ countrybcivilorganization_ countryahumanitarianorganization_ townc_.
Variable event_82_102 : accept_team_ sufferterragovernment_ countryahumanitarianorganization_ coastvillage_ n5_.
Variable event_83_103 : accept_team_ sufferterragovernment_ countryahumanitarianorganization_ coastvillage_ n6_.
Variable event_84_104 : accept_team_ sufferterragovernment_ countryacivilorganization_ coastvillage_ n6_.
Variable event_85_105 : accept_team_ sufferterragovernment_ countryafirstaidorganization_ coastvillage_ n6_.
Variable event_86_106 : the_agent_in_all_proposed_teams_ sufferterragovernment_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_87_107 : any_agent_in_all_proposed_teams_ sufferterragovernment_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_88_108 : accept_number_ christiansufferterrahumanitarianorganization_ n2_.
Variable event_89_109 : accept_number_ countryahumanitarianorganization_ n5_.
Variable event_90_110 : accept_team_ christiansufferterrahumanitarianorganization_ countryahumanitarianorganization_ coastvillage_ n5_.
Variable event_91_111 : accept_team_ christiansufferterrahumanitarianorganization_ countryahumanitarianorganization_ coastvillage_ n6_.
Variable event_92_112 : accept_team_ christiansufferterrahumanitarianorganization_ countryacivilorganization_ coastvillage_ n6_.
Variable event_93_113 : accept_team_ christiansufferterrahumanitarianorganization_ countryafirstaidorganization_ coastvillage_ n6_.
Variable event_94_114 : the_agent_in_all_proposed_teams_ christiansufferterrahumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_95_115 : any_agent_in_all_proposed_teams_ christiansufferterrahumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_.
Variable event_96_116 : accept_team_ countrycmedicalorganization_ christiancountrychumanitarianorganization_ coastvillage_ n6_.
Variable event_97_117 : accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ coastvillage_ n6_.
Variable event_98_118 : accept_number_ muslimcountrybhumanitarianorganization_ n3_.
Variable event_99_119 : accept_team_ muslimcountrybhumanitarianorganization_ countryccivilorganization_ townc_ n4_.
Variable event_100_120 : accept_team_ muslimcountrybhumanitarianorganization_ countrybcivilorganization_ townc_ n6_.
Variable event_101_121 : accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ townc_ n6_.
Variable event_102_122 : accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ townc_ n6_.
Variable event_103_123 : accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ townc_ n6_.
Variable event_104_124 : the_agent_in_all_proposed_teams_ muslimcountrybhumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_105_125 : any_agent_in_all_proposed_teams_ muslimcountrybhumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_106_126 : accept_team_ countryacivilorganization_ countryahumanitarianorganization_ townc_ n6_.
Variable event_107_127 : accept_team_ countryafirstaidorganization_ countryahumanitarianorganization_ townc_ n6_.
Variable event_108_128 : accept_team_ christiancountrychumanitarianorganization_ countryccivilorganization_ townc_ n4_.
Variable event_109_129 : accept_team_ christiancountrychumanitarianorganization_ muslimcountrybhumanitarianorganization_ townc_ n6_.
Variable event_110_130 : accept_team_ christiancountrychumanitarianorganization_ countrybcivilorganization_ townc_ n6_.
Variable event_111_131 : accept_team_ christiancountrychumanitarianorganization_ countrybhumanitarianorganization_ townc_ n6_.
Variable event_112_132 : accept_team_ christiancountrychumanitarianorganization_ countrycmedicalorganization_ townc_ n6_.
Variable event_113_133 : the_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_114_134 : any_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_115_135 : ~(accept_team_ countryccivilorganization_ muslimcountrybhumanitarianorganization_ townc_ n6_).
Variable event_116_136 : ~(accept_team_ countryccivilorganization_ countrybcivilorganization_ townc_ n6_).
Variable event_117_137 : ~(accept_team_ countryccivilorganization_ countrybhumanitarianorganization_ townc_ n6_).
Variable event_118_138 : ~(accept_team_ countryccivilorganization_ christiancountrychumanitarianorganization_ townc_ n6_).
Variable event_119_139 : ~(accept_team_ countryccivilorganization_ countrycmedicalorganization_ townc_ n6_).
Variable event_120_140 : the_agent_in_all_proposed_teams_ countryccivilorganization_ countryahumanitarianorganization_ townc_.
Variable event_121_141 : any_agent_in_all_proposed_teams_ countryccivilorganization_ countryahumanitarianorganization_ townc_.
Variable event_122_142 : accept_team_ countrybhumanitarianorganization_ countrybcivilorganization_ townc_ n2_.
Variable event_123_143 : accept_team_ countrybhumanitarianorganization_ muslimcountrybhumanitarianorganization_ townc_ n6_.
Variable event_124_144 : accept_team_ sufferterragovernment_ countryahumanitarianorganization_ townc_ n6_.
Variable event_125_145 : accept_team_ christiansufferterrahumanitarianorganization_ countryahumanitarianorganization_ townc_ n6_.
Variable event_126_146 : accept_team_ countryamedicalorganization_ countryahumanitarianorganization_ townc_ n6_.
Variable event_127_147 : accept_team_ countrycmedicalorganization_ countryccivilorganization_ townc_ n4_.
Variable event_128_148 : accept_team_ countrycmedicalorganization_ muslimcountrybhumanitarianorganization_ townc_ n6_.
Variable event_129_149 : accept_team_ countrycmedicalorganization_ countrybcivilorganization_ townc_ n6_.
Variable event_130_150 : accept_team_ countrycmedicalorganization_ countrybhumanitarianorganization_ townc_ n6_.
Variable event_131_151 : accept_team_ countrycmedicalorganization_ christiancountrychumanitarianorganization_ townc_ n6_.
Variable event_132_152 : the_agent_in_all_proposed_teams_ countrycmedicalorganization_ countryahumanitarianorganization_ townc_.
Variable event_133_153 : any_agent_in_all_proposed_teams_ countrycmedicalorganization_ countryahumanitarianorganization_ townc_.
Variable event_134_154 : accept_team_ countrybhumanitarianorganization_ countrybcivilorganization_ townc_ n6_.
Variable event_135_155 : accept_team_ countrybhumanitarianorganization_ christiancountrychumanitarianorganization_ townc_ n6_.
Variable event_136_156 : accept_team_ countrybhumanitarianorganization_ countrycmedicalorganization_ townc_ n6_.
Variable event_137_157 : the_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_138_158 : any_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ countryahumanitarianorganization_ townc_.
Variable event_139_159 : accept_team_ christiansufferterrahumanitarianorganization_ countryahumanitarianorganization_ cityb_ n6_.
Variable event_140_160 : accept_number_ christiansufferterrahumanitarianorganization_ n6_.
Variable event_141_161 : the_agent_in_all_proposed_teams_ christiansufferterrahumanitarianorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_142_162 : any_agent_in_all_proposed_teams_ christiansufferterrahumanitarianorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_143_163 : ~(accept_team_ countryccivilorganization_ countrybhumanitarianorganization_ cityb_ n5_).
Variable event_144_164 : ~(accept_team_ countryccivilorganization_ countrybhumanitarianorganization_ cityb_ n6_).
Variable event_145_165 : accept_team_ sufferterragovernment_ countryahumanitarianorganization_ cityb_ n6_.
Variable event_146_166 : the_agent_in_all_proposed_teams_ sufferterragovernment_ countrybhumanitarianorganization_ cityb_.
Variable event_147_167 : any_agent_in_all_proposed_teams_ sufferterragovernment_ countrybhumanitarianorganization_ cityb_.
Variable event_148_168 : accept_team_ countryafirstaidorganization_ countryahumanitarianorganization_ cityb_ n6_.
Variable event_149_169 : accept_number_ countryafirstaidorganization_ n6_.
Variable event_150_170 : the_agent_in_all_proposed_teams_ countryafirstaidorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_151_171 : any_agent_in_all_proposed_teams_ countryafirstaidorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_152_172 : accept_team_ countryafirstaidorganization_ sufferterragovernment_ towna_ n5_.
Variable event_153_173 : accept_team_ countryafirstaidorganization_ sufferterragovernment_ towna_ n6_.
Variable event_154_174 : accept_team_ countrycmedicalorganization_ countrybhumanitarianorganization_ cityb_ n5_.
Variable event_155_175 : accept_team_ countrycmedicalorganization_ countrybhumanitarianorganization_ cityb_ n6_.
Variable event_156_176 : accept_team_ countryamedicalorganization_ countryahumanitarianorganization_ cityb_ n6_.
Variable event_157_177 : accept_number_ countryamedicalorganization_ n6_.
Variable event_158_178 : the_agent_in_all_proposed_teams_ countryamedicalorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_159_179 : any_agent_in_all_proposed_teams_ countryamedicalorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_160_180 : accept_team_ countrybcivilorganization_ countrybhumanitarianorganization_ cityb_ n5_.
Variable event_161_181 : accept_team_ countrybcivilorganization_ countrybhumanitarianorganization_ cityb_ n6_.
Variable event_162_182 : accept_team_ christiancountrychumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n5_.
Variable event_163_183 : accept_team_ christiancountrychumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n6_.
Variable event_164_184 : the_agent_in_all_proposed_teams_ countryahumanitarianorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_165_185 : any_agent_in_all_proposed_teams_ countryahumanitarianorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_166_186 : accept_number_ countryahumanitarianorganization_ n6_.
Variable event_167_187 : accept_team_ countryacivilorganization_ countryahumanitarianorganization_ cityb_ n6_.
Variable event_168_188 : accept_number_ countryacivilorganization_ n6_.
Variable event_169_189 : the_agent_in_all_proposed_teams_ countryacivilorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_170_190 : any_agent_in_all_proposed_teams_ countryacivilorganization_ countrybhumanitarianorganization_ cityb_.
Variable event_171_191 : accept_number_ countrybhumanitarianorganization_ n5_.
Variable event_172_192 : accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n5_.
Variable event_173_193 : accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ cityb_ n6_.
Variable event_174_194 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrybcivilorganization_ towna_ n2_).
Variable event_175_195 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n2_).
Variable event_176_196 : ~(accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ towna_ n2_).
Variable event_177_197 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countryccivilorganization_ towna_ n2_).
Variable event_178_198 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrybcivilorganization_ towna_ n3_).
Variable event_179_199 : ~(accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ towna_ n3_).
Variable event_180_200 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n3_).
Variable event_181_201 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countryccivilorganization_ towna_ n3_).
Variable event_182_202 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ towna_ n2_).
Variable event_183_203 : accept_number_ muslimcountrybhumanitarianorganization_ n2_.
Variable event_184_204 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countryccivilorganization_ towna_ n4_).
Variable event_185_205 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrybcivilorganization_ towna_ n6_).
Variable event_186_206 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrybhumanitarianorganization_ towna_ n6_).
Variable event_187_207 : ~(accept_team_ muslimcountrybhumanitarianorganization_ christiancountrychumanitarianorganization_ towna_ n6_).
Variable event_188_208 : accept_team_ countryamedicalorganization_ sufferterragovernment_ towna_ n5_.
Variable event_189_209 : accept_team_ countryamedicalorganization_ sufferterragovernment_ towna_ n6_.
Variable event_190_210 : accept_team_ countryahumanitarianorganization_ sufferterragovernment_ towna_ n5_.
Variable event_191_211 : accept_team_ countryahumanitarianorganization_ sufferterragovernment_ towna_ n6_.
Variable event_192_212 : accept_number_ christiancountrychumanitarianorganization_ n2_.
Variable event_193_213 : accept_team_ countrybhumanitarianorganization_ countrybcivilorganization_ towna_ n3_.
Variable event_194_214 : accept_team_ countrybhumanitarianorganization_ christiancountrychumanitarianorganization_ towna_ n3_.
Variable event_195_215 : accept_team_ countrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n3_.
Variable event_196_216 : accept_team_ countrybhumanitarianorganization_ countryccivilorganization_ towna_ n3_.
Variable event_197_217 : accept_number_ countrybhumanitarianorganization_ n2_.
Variable event_198_218 : accept_team_ countrybhumanitarianorganization_ countrybcivilorganization_ towna_ n6_.
Variable event_199_219 : accept_team_ countrybhumanitarianorganization_ christiancountrychumanitarianorganization_ towna_ n6_.
Variable event_200_220 : accept_team_ countrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n6_.
Variable event_201_221 : the_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ sufferterragovernment_ towna_.
Variable event_202_222 : any_agent_in_all_proposed_teams_ countrybhumanitarianorganization_ sufferterragovernment_ towna_.
Variable event_203_223 : accept_number_ countrybcivilorganization_ n2_.
Variable event_204_224 : accept_number_ countrybcivilorganization_ n3_.
Variable event_205_225 : accept_team_ countrybcivilorganization_ countryccivilorganization_ towna_ n4_.
Variable event_206_226 : accept_team_ countrybcivilorganization_ countrybhumanitarianorganization_ towna_ n6_.
Variable event_207_227 : accept_team_ countrybcivilorganization_ christiancountrychumanitarianorganization_ towna_ n6_.
Variable event_208_228 : accept_team_ countrybcivilorganization_ countrycmedicalorganization_ towna_ n6_.
Variable event_209_229 : the_agent_in_all_proposed_teams_ countrybcivilorganization_ sufferterragovernment_ towna_.
Variable event_210_230 : any_agent_in_all_proposed_teams_ countrybcivilorganization_ sufferterragovernment_ towna_.
Variable event_211_231 : accept_number_ sufferterragovernment_ n2_.
Variable event_212_232 : ~(accept_team_ christiansufferterrahumanitarianorganization_ sufferterragovernment_ towna_ n2_).
Variable event_213_233 : ~(accept_team_ christiansufferterrahumanitarianorganization_ sufferterragovernment_ towna_ n6_).
Variable event_214_234 : accept_number_ countryccivilorganization_ n2_.
Variable event_215_235 : accept_number_ countryccivilorganization_ n3_.
Variable event_216_236 : ~(accept_team_ countryccivilorganization_ countrybcivilorganization_ towna_ n6_).
Variable event_217_237 : ~(accept_team_ countryccivilorganization_ countrybhumanitarianorganization_ towna_ n6_).
Variable event_218_238 : ~(accept_team_ countryccivilorganization_ christiancountrychumanitarianorganization_ towna_ n6_).
Variable event_219_239 : ~(accept_team_ countryccivilorganization_ countrycmedicalorganization_ towna_ n6_).
Variable event_220_240 : the_agent_in_all_proposed_teams_ countryccivilorganization_ sufferterragovernment_ towna_.
Variable event_221_241 : any_agent_in_all_proposed_teams_ countryccivilorganization_ sufferterragovernment_ towna_.
Variable event_222_242 : accept_number_ sufferterragovernment_ n5_.
Variable event_223_243 : accept_team_ countryacivilorganization_ sufferterragovernment_ towna_ n5_.
Variable event_224_244 : accept_number_ sufferterragovernment_ n6_.
Variable event_225_245 : accept_team_ countryacivilorganization_ sufferterragovernment_ towna_ n6_.
Variable event_226_246 : accept_number_ countrycmedicalorganization_ n2_.
Variable event_227_247 : accept_number_ countrycmedicalorganization_ n3_.
Variable event_228_248 : accept_team_ countrycmedicalorganization_ countryccivilorganization_ towna_ n4_.
Variable event_229_249 : accept_team_ countrycmedicalorganization_ countrybcivilorganization_ towna_ n6_.
Variable event_230_250 : accept_team_ countrycmedicalorganization_ countrybhumanitarianorganization_ towna_ n6_.
Variable event_231_251 : accept_team_ countrycmedicalorganization_ christiancountrychumanitarianorganization_ towna_ n6_.
Variable event_232_252 : the_agent_in_all_proposed_teams_ countrycmedicalorganization_ sufferterragovernment_ towna_.
Variable event_233_253 : any_agent_in_all_proposed_teams_ countrycmedicalorganization_ sufferterragovernment_ towna_.
Variable event_234_254 : accept_number_ christiancountrychumanitarianorganization_ n3_.
Variable event_235_255 : accept_number_ countryccivilorganization_ n4_.
Variable event_236_256 : accept_team_ christiancountrychumanitarianorganization_ countryccivilorganization_ towna_ n4_.
Variable event_237_257 : accept_number_ countrybcivilorganization_ n6_.
Variable event_238_258 : accept_team_ christiancountrychumanitarianorganization_ countrybcivilorganization_ towna_ n6_.
Variable event_239_259 : accept_number_ countrybhumanitarianorganization_ n6_.
Variable event_240_260 : accept_team_ christiancountrychumanitarianorganization_ countrybhumanitarianorganization_ towna_ n6_.
Variable event_241_261 : accept_team_ christiancountrychumanitarianorganization_ countrycmedicalorganization_ towna_ n6_.
Variable event_242_262 : accept_number_ christiancountrychumanitarianorganization_ n6_.
Variable event_243_263 : the_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ sufferterragovernment_ towna_.
Variable event_244_264 : any_agent_in_all_proposed_teams_ christiancountrychumanitarianorganization_ sufferterragovernment_ towna_.
Variable event_245_265 : accept_number_ countrycmedicalorganization_ n6_.
Variable event_246_266 : ~(accept_team_ muslimcountrybhumanitarianorganization_ countrycmedicalorganization_ towna_ n6_).
Variable event_247_267 : accept_number_ muslimcountrybhumanitarianorganization_ n6_.
Variable event_248_268 : the_agent_not_in_any_proposed_teams_ muslimcountrybhumanitarianorganization_ sufferterragovernment_ towna_.
Variable event_249_269 : any_agent_in_all_proposed_teams_ muslimcountrybhumanitarianorganization_ sufferterragovernment_ towna_.
Variable rdn0_270 : rdn_translate_ n0_ (rdn_pos_ (rdnn_ n0_)).
Variable rdn1_271 : rdn_translate_ n1_ (rdn_pos_ (rdnn_ n1_)).
Variable rdn2_272 : rdn_translate_ n2_ (rdn_pos_ (rdnn_ n2_)).
Variable rdn3_273 : rdn_translate_ n3_ (rdn_pos_ (rdnn_ n3_)).
Variable rdn4_274 : rdn_translate_ n4_ (rdn_pos_ (rdnn_ n4_)).
Variable rdn5_275 : rdn_translate_ n5_ (rdn_pos_ (rdnn_ n5_)).
Variable rdn6_276 : rdn_translate_ n6_ (rdn_pos_ (rdnn_ n6_)).
Variable rdn7_277 : rdn_translate_ n7_ (rdn_pos_ (rdnn_ n7_)).
Variable rdn8_278 : rdn_translate_ n8_ (rdn_pos_ (rdnn_ n8_)).
Variable rdn9_279 : rdn_translate_ n9_ (rdn_pos_ (rdnn_ n9_)).
Variable rdn10_280 : rdn_translate_ n10_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n1_))).
Variable rdn11_281 : rdn_translate_ n11_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n1_))).
Variable rdn12_282 : rdn_translate_ n12_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n1_))).
Variable rdn13_283 : rdn_translate_ n13_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n1_))).
Variable rdn14_284 : rdn_translate_ n14_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n1_))).
Variable rdn15_285 : rdn_translate_ n15_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n1_))).
Variable rdn16_286 : rdn_translate_ n16_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n1_))).
Variable rdn17_287 : rdn_translate_ n17_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n1_))).
Variable rdn18_288 : rdn_translate_ n18_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n1_))).
Variable rdn19_289 : rdn_translate_ n19_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n1_))).
Variable rdn20_290 : rdn_translate_ n20_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n2_))).
Variable rdn21_291 : rdn_translate_ n21_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n2_))).
Variable rdn22_292 : rdn_translate_ n22_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n2_))).
Variable rdn23_293 : rdn_translate_ n23_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n2_))).
Variable rdn24_294 : rdn_translate_ n24_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n2_))).
Variable rdn25_295 : rdn_translate_ n25_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n2_))).
Variable rdn26_296 : rdn_translate_ n26_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n2_))).
Variable rdn27_297 : rdn_translate_ n27_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n2_))).
Variable rdn28_298 : rdn_translate_ n28_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n2_))).
Variable rdn29_299 : rdn_translate_ n29_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n2_))).
Variable rdn30_300 : rdn_translate_ n30_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n3_))).
Variable rdn31_301 : rdn_translate_ n31_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n3_))).
Variable rdn32_302 : rdn_translate_ n32_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n3_))).
Variable rdn33_303 : rdn_translate_ n33_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n3_))).
Variable rdn34_304 : rdn_translate_ n34_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n3_))).
Variable rdn35_305 : rdn_translate_ n35_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n3_))).
Variable rdn36_306 : rdn_translate_ n36_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n3_))).
Variable rdn37_307 : rdn_translate_ n37_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n3_))).
Variable rdn38_308 : rdn_translate_ n38_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n3_))).
Variable rdn39_309 : rdn_translate_ n39_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n3_))).
Variable rdn40_310 : rdn_translate_ n40_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n4_))).
Variable rdn41_311 : rdn_translate_ n41_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n4_))).
Variable rdn42_312 : rdn_translate_ n42_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n4_))).
Variable rdn43_313 : rdn_translate_ n43_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n4_))).
Variable rdn44_314 : rdn_translate_ n44_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n4_))).
Variable rdn45_315 : rdn_translate_ n45_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n4_))).
Variable rdn46_316 : rdn_translate_ n46_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n4_))).
Variable rdn47_317 : rdn_translate_ n47_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n4_))).
Variable rdn48_318 : rdn_translate_ n48_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n4_))).
Variable rdn49_319 : rdn_translate_ n49_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n4_))).
Variable rdn50_320 : rdn_translate_ n50_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n5_))).
Variable rdn51_321 : rdn_translate_ n51_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n5_))).
Variable rdn52_322 : rdn_translate_ n52_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n5_))).
Variable rdn53_323 : rdn_translate_ n53_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n5_))).
Variable rdn54_324 : rdn_translate_ n54_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n5_))).
Variable rdn55_325 : rdn_translate_ n55_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n5_))).
Variable rdn56_326 : rdn_translate_ n56_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n5_))).
Variable rdn57_327 : rdn_translate_ n57_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n5_))).
Variable rdn58_328 : rdn_translate_ n58_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n5_))).
Variable rdn59_329 : rdn_translate_ n59_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n5_))).
Variable rdn60_330 : rdn_translate_ n60_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n6_))).
Variable rdn61_331 : rdn_translate_ n61_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n6_))).
Variable rdn62_332 : rdn_translate_ n62_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n6_))).
Variable rdn63_333 : rdn_translate_ n63_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n6_))).
Variable rdn64_334 : rdn_translate_ n64_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n6_))).
Variable rdn65_335 : rdn_translate_ n65_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n6_))).
Variable rdn66_336 : rdn_translate_ n66_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n6_))).
Variable rdn67_337 : rdn_translate_ n67_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n6_))).
Variable rdn68_338 : rdn_translate_ n68_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n6_))).
Variable rdn69_339 : rdn_translate_ n69_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n6_))).
Variable rdn70_340 : rdn_translate_ n70_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n7_))).
Variable rdn71_341 : rdn_translate_ n71_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n7_))).
Variable rdn72_342 : rdn_translate_ n72_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n7_))).
Variable rdn73_343 : rdn_translate_ n73_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n7_))).
Variable rdn74_344 : rdn_translate_ n74_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n7_))).
Variable rdn75_345 : rdn_translate_ n75_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n7_))).
Variable rdn76_346 : rdn_translate_ n76_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n7_))).
Variable rdn77_347 : rdn_translate_ n77_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n7_))).
Variable rdn78_348 : rdn_translate_ n78_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n7_))).
Variable rdn79_349 : rdn_translate_ n79_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n7_))).
Variable rdn80_350 : rdn_translate_ n80_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n8_))).
Variable rdn81_351 : rdn_translate_ n81_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n8_))).
Variable rdn82_352 : rdn_translate_ n82_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n8_))).
Variable rdn83_353 : rdn_translate_ n83_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n8_))).
Variable rdn84_354 : rdn_translate_ n84_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n8_))).
Variable rdn85_355 : rdn_translate_ n85_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n8_))).
Variable rdn86_356 : rdn_translate_ n86_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n8_))).
Variable rdn87_357 : rdn_translate_ n87_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n8_))).
Variable rdn88_358 : rdn_translate_ n88_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n8_))).
Variable rdn89_359 : rdn_translate_ n89_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n8_))).
Variable rdn90_360 : rdn_translate_ n90_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdnn_ n9_))).
Variable rdn91_361 : rdn_translate_ n91_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdnn_ n9_))).
Variable rdn92_362 : rdn_translate_ n92_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdnn_ n9_))).
Variable rdn93_363 : rdn_translate_ n93_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdnn_ n9_))).
Variable rdn94_364 : rdn_translate_ n94_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdnn_ n9_))).
Variable rdn95_365 : rdn_translate_ n95_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdnn_ n9_))).
Variable rdn96_366 : rdn_translate_ n96_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdnn_ n9_))).
Variable rdn97_367 : rdn_translate_ n97_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdnn_ n9_))).
Variable rdn98_368 : rdn_translate_ n98_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdnn_ n9_))).
Variable rdn99_369 : rdn_translate_ n99_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdnn_ n9_))).
Variable rdn100_370 : rdn_translate_ n100_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn101_371 : rdn_translate_ n101_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn102_372 : rdn_translate_ n102_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn103_373 : rdn_translate_ n103_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn104_374 : rdn_translate_ n104_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn105_375 : rdn_translate_ n105_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn106_376 : rdn_translate_ n106_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn107_377 : rdn_translate_ n107_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn108_378 : rdn_translate_ n108_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn109_379 : rdn_translate_ n109_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdn110_380 : rdn_translate_ n110_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn111_381 : rdn_translate_ n111_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn112_382 : rdn_translate_ n112_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn113_383 : rdn_translate_ n113_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn114_384 : rdn_translate_ n114_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn115_385 : rdn_translate_ n115_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn116_386 : rdn_translate_ n116_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn117_387 : rdn_translate_ n117_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn118_388 : rdn_translate_ n118_ (rdn_pos_ (rdn_ (rdnn_ n8_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn119_389 : rdn_translate_ n119_ (rdn_pos_ (rdn_ (rdnn_ n9_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdn120_390 : rdn_translate_ n120_ (rdn_pos_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn121_391 : rdn_translate_ n121_ (rdn_pos_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn122_392 : rdn_translate_ n122_ (rdn_pos_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn123_393 : rdn_translate_ n123_ (rdn_pos_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn124_394 : rdn_translate_ n124_ (rdn_pos_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn125_395 : rdn_translate_ n125_ (rdn_pos_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn126_396 : rdn_translate_ n126_ (rdn_pos_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn127_397 : rdn_translate_ n127_ (rdn_pos_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn1_398 : rdn_translate_ nn1_ (rdn_neg_ (rdnn_ n1_)).
Variable rdnn2_399 : rdn_translate_ nn2_ (rdn_neg_ (rdnn_ n2_)).
Variable rdnn3_400 : rdn_translate_ nn3_ (rdn_neg_ (rdnn_ n3_)).
Variable rdnn4_401 : rdn_translate_ nn4_ (rdn_neg_ (rdnn_ n4_)).
Variable rdnn5_402 : rdn_translate_ nn5_ (rdn_neg_ (rdnn_ n5_)).
Variable rdnn6_403 : rdn_translate_ nn6_ (rdn_neg_ (rdnn_ n6_)).
Variable rdnn7_404 : rdn_translate_ nn7_ (rdn_neg_ (rdnn_ n7_)).
Variable rdnn8_405 : rdn_translate_ nn8_ (rdn_neg_ (rdnn_ n8_)).
Variable rdnn9_406 : rdn_translate_ nn9_ (rdn_neg_ (rdnn_ n9_)).
Variable rdnn10_407 : rdn_translate_ nn10_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n1_))).
Variable rdnn11_408 : rdn_translate_ nn11_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n1_))).
Variable rdnn12_409 : rdn_translate_ nn12_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n1_))).
Variable rdnn13_410 : rdn_translate_ nn13_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n1_))).
Variable rdnn14_411 : rdn_translate_ nn14_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n1_))).
Variable rdnn15_412 : rdn_translate_ nn15_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n1_))).
Variable rdnn16_413 : rdn_translate_ nn16_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n1_))).
Variable rdnn17_414 : rdn_translate_ nn17_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n1_))).
Variable rdnn18_415 : rdn_translate_ nn18_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n1_))).
Variable rdnn19_416 : rdn_translate_ nn19_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n1_))).
Variable rdnn20_417 : rdn_translate_ nn20_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n2_))).
Variable rdnn21_418 : rdn_translate_ nn21_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n2_))).
Variable rdnn22_419 : rdn_translate_ nn22_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n2_))).
Variable rdnn23_420 : rdn_translate_ nn23_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n2_))).
Variable rdnn24_421 : rdn_translate_ nn24_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n2_))).
Variable rdnn25_422 : rdn_translate_ nn25_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n2_))).
Variable rdnn26_423 : rdn_translate_ nn26_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n2_))).
Variable rdnn27_424 : rdn_translate_ nn27_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n2_))).
Variable rdnn28_425 : rdn_translate_ nn28_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n2_))).
Variable rdnn29_426 : rdn_translate_ nn29_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n2_))).
Variable rdnn30_427 : rdn_translate_ nn30_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n3_))).
Variable rdnn31_428 : rdn_translate_ nn31_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n3_))).
Variable rdnn32_429 : rdn_translate_ nn32_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n3_))).
Variable rdnn33_430 : rdn_translate_ nn33_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n3_))).
Variable rdnn34_431 : rdn_translate_ nn34_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n3_))).
Variable rdnn35_432 : rdn_translate_ nn35_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n3_))).
Variable rdnn36_433 : rdn_translate_ nn36_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n3_))).
Variable rdnn37_434 : rdn_translate_ nn37_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n3_))).
Variable rdnn38_435 : rdn_translate_ nn38_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n3_))).
Variable rdnn39_436 : rdn_translate_ nn39_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n3_))).
Variable rdnn40_437 : rdn_translate_ nn40_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n4_))).
Variable rdnn41_438 : rdn_translate_ nn41_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n4_))).
Variable rdnn42_439 : rdn_translate_ nn42_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n4_))).
Variable rdnn43_440 : rdn_translate_ nn43_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n4_))).
Variable rdnn44_441 : rdn_translate_ nn44_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n4_))).
Variable rdnn45_442 : rdn_translate_ nn45_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n4_))).
Variable rdnn46_443 : rdn_translate_ nn46_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n4_))).
Variable rdnn47_444 : rdn_translate_ nn47_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n4_))).
Variable rdnn48_445 : rdn_translate_ nn48_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n4_))).
Variable rdnn49_446 : rdn_translate_ nn49_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n4_))).
Variable rdnn50_447 : rdn_translate_ nn50_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n5_))).
Variable rdnn51_448 : rdn_translate_ nn51_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n5_))).
Variable rdnn52_449 : rdn_translate_ nn52_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n5_))).
Variable rdnn53_450 : rdn_translate_ nn53_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n5_))).
Variable rdnn54_451 : rdn_translate_ nn54_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n5_))).
Variable rdnn55_452 : rdn_translate_ nn55_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n5_))).
Variable rdnn56_453 : rdn_translate_ nn56_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n5_))).
Variable rdnn57_454 : rdn_translate_ nn57_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n5_))).
Variable rdnn58_455 : rdn_translate_ nn58_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n5_))).
Variable rdnn59_456 : rdn_translate_ nn59_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n5_))).
Variable rdnn60_457 : rdn_translate_ nn60_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n6_))).
Variable rdnn61_458 : rdn_translate_ nn61_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n6_))).
Variable rdnn62_459 : rdn_translate_ nn62_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n6_))).
Variable rdnn63_460 : rdn_translate_ nn63_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n6_))).
Variable rdnn64_461 : rdn_translate_ nn64_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n6_))).
Variable rdnn65_462 : rdn_translate_ nn65_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n6_))).
Variable rdnn66_463 : rdn_translate_ nn66_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n6_))).
Variable rdnn67_464 : rdn_translate_ nn67_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n6_))).
Variable rdnn68_465 : rdn_translate_ nn68_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n6_))).
Variable rdnn69_466 : rdn_translate_ nn69_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n6_))).
Variable rdnn70_467 : rdn_translate_ nn70_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n7_))).
Variable rdnn71_468 : rdn_translate_ nn71_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n7_))).
Variable rdnn72_469 : rdn_translate_ nn72_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n7_))).
Variable rdnn73_470 : rdn_translate_ nn73_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n7_))).
Variable rdnn74_471 : rdn_translate_ nn74_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n7_))).
Variable rdnn75_472 : rdn_translate_ nn75_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n7_))).
Variable rdnn76_473 : rdn_translate_ nn76_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n7_))).
Variable rdnn77_474 : rdn_translate_ nn77_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n7_))).
Variable rdnn78_475 : rdn_translate_ nn78_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n7_))).
Variable rdnn79_476 : rdn_translate_ nn79_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n7_))).
Variable rdnn80_477 : rdn_translate_ nn80_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n8_))).
Variable rdnn81_478 : rdn_translate_ nn81_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n8_))).
Variable rdnn82_479 : rdn_translate_ nn82_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n8_))).
Variable rdnn83_480 : rdn_translate_ nn83_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n8_))).
Variable rdnn84_481 : rdn_translate_ nn84_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n8_))).
Variable rdnn85_482 : rdn_translate_ nn85_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n8_))).
Variable rdnn86_483 : rdn_translate_ nn86_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n8_))).
Variable rdnn87_484 : rdn_translate_ nn87_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n8_))).
Variable rdnn88_485 : rdn_translate_ nn88_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n8_))).
Variable rdnn89_486 : rdn_translate_ nn89_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n8_))).
Variable rdnn90_487 : rdn_translate_ nn90_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdnn_ n9_))).
Variable rdnn91_488 : rdn_translate_ nn91_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdnn_ n9_))).
Variable rdnn92_489 : rdn_translate_ nn92_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdnn_ n9_))).
Variable rdnn93_490 : rdn_translate_ nn93_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdnn_ n9_))).
Variable rdnn94_491 : rdn_translate_ nn94_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdnn_ n9_))).
Variable rdnn95_492 : rdn_translate_ nn95_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdnn_ n9_))).
Variable rdnn96_493 : rdn_translate_ nn96_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdnn_ n9_))).
Variable rdnn97_494 : rdn_translate_ nn97_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdnn_ n9_))).
Variable rdnn98_495 : rdn_translate_ nn98_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdnn_ n9_))).
Variable rdnn99_496 : rdn_translate_ nn99_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdnn_ n9_))).
Variable rdnn100_497 : rdn_translate_ nn100_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn101_498 : rdn_translate_ nn101_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn102_499 : rdn_translate_ nn102_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn103_500 : rdn_translate_ nn103_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn104_501 : rdn_translate_ nn104_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn105_502 : rdn_translate_ nn105_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn106_503 : rdn_translate_ nn106_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn107_504 : rdn_translate_ nn107_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn108_505 : rdn_translate_ nn108_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn109_506 : rdn_translate_ nn109_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdn_ (rdnn_ n0_) (rdnn_ n1_)))).
Variable rdnn110_507 : rdn_translate_ nn110_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn111_508 : rdn_translate_ nn111_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn112_509 : rdn_translate_ nn112_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn113_510 : rdn_translate_ nn113_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn114_511 : rdn_translate_ nn114_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn115_512 : rdn_translate_ nn115_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn116_513 : rdn_translate_ nn116_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn117_514 : rdn_translate_ nn117_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn118_515 : rdn_translate_ nn118_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn119_516 : rdn_translate_ nn119_ (rdn_neg_ (rdn_ (rdnn_ n9_) (rdn_ (rdnn_ n1_) (rdnn_ n1_)))).
Variable rdnn120_517 : rdn_translate_ nn120_ (rdn_neg_ (rdn_ (rdnn_ n0_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn121_518 : rdn_translate_ nn121_ (rdn_neg_ (rdn_ (rdnn_ n1_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn122_519 : rdn_translate_ nn122_ (rdn_neg_ (rdn_ (rdnn_ n2_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn123_520 : rdn_translate_ nn123_ (rdn_neg_ (rdn_ (rdnn_ n3_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn124_521 : rdn_translate_ nn124_ (rdn_neg_ (rdn_ (rdnn_ n4_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn125_522 : rdn_translate_ nn125_ (rdn_neg_ (rdn_ (rdnn_ n5_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn126_523 : rdn_translate_ nn126_ (rdn_neg_ (rdn_ (rdnn_ n6_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn127_524 : rdn_translate_ nn127_ (rdn_neg_ (rdn_ (rdnn_ n7_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdnn128_525 : rdn_translate_ nn128_ (rdn_neg_ (rdn_ (rdnn_ n8_) (rdn_ (rdnn_ n2_) (rdnn_ n1_)))).
Variable rdn_digit1_526 : rdn_non_zero_digit_ (rdnn_ n1_).
Variable rdn_digit2_527 : rdn_non_zero_digit_ (rdnn_ n2_).
Variable rdn_digit3_528 : rdn_non_zero_digit_ (rdnn_ n3_).
Variable rdn_digit4_529 : rdn_non_zero_digit_ (rdnn_ n4_).
Variable rdn_digit5_530 : rdn_non_zero_digit_ (rdnn_ n5_).
Variable rdn_digit6_531 : rdn_non_zero_digit_ (rdnn_ n6_).
Variable rdn_digit7_532 : rdn_non_zero_digit_ (rdnn_ n7_).
Variable rdn_digit8_533 : rdn_non_zero_digit_ (rdnn_ n8_).
Variable rdn_digit9_534 : rdn_non_zero_digit_ (rdnn_ n9_).
Variable rdn_positive_less01_535 : rdn_positive_less_ (rdnn_ n0_) (rdnn_ n1_).
Variable rdn_positive_less12_536 : rdn_positive_less_ (rdnn_ n1_) (rdnn_ n2_).
Variable rdn_positive_less23_537 : rdn_positive_less_ (rdnn_ n2_) (rdnn_ n3_).
Variable rdn_positive_less34_538 : rdn_positive_less_ (rdnn_ n3_) (rdnn_ n4_).
Variable rdn_positive_less45_539 : rdn_positive_less_ (rdnn_ n4_) (rdnn_ n5_).
Variable rdn_positive_less56_540 : rdn_positive_less_ (rdnn_ n5_) (rdnn_ n6_).
Variable rdn_positive_less67_541 : rdn_positive_less_ (rdnn_ n6_) (rdnn_ n7_).
Variable rdn_positive_less78_542 : rdn_positive_less_ (rdnn_ n7_) (rdnn_ n8_).
Variable rdn_positive_less89_543 : rdn_positive_less_ (rdnn_ n8_) (rdnn_ n9_).
Variable rdn_positive_less_transitivity_544 : (forall X Y Z : Universe, ((rdn_positive_less_ (rdnn_ X) (rdnn_ Y) /\ rdn_positive_less_ (rdnn_ Y) (rdnn_ Z)) -> rdn_positive_less_ (rdnn_ X) (rdnn_ Z))).
Variable rdn_positive_less_multi_digit_high_545 : (forall Ds Os Db Ob : Universe, (rdn_positive_less_ Os Ob -> rdn_positive_less_ (rdn_ (rdnn_ Ds) Os) (rdn_ (rdnn_ Db) Ob))).
Variable rdn_positive_less_multi_digit_low_546 : (forall Ds O Db : Universe, ((rdn_positive_less_ (rdnn_ Ds) (rdnn_ Db) /\ rdn_non_zero_ O) -> rdn_positive_less_ (rdn_ (rdnn_ Ds) O) (rdn_ (rdnn_ Db) O))).
Variable rdn_extra_digits_positive_less_547 : (forall D Db Ob : Universe, (rdn_non_zero_ Ob -> rdn_positive_less_ (rdnn_ D) (rdn_ (rdnn_ Db) Ob))).
Variable rdn_non_zero_by_digit_548 : (forall X : Universe, (rdn_non_zero_digit_ (rdnn_ X) -> rdn_non_zero_ (rdnn_ X))).
Variable rdn_non_zero_by_structure_549 : (forall D O : Universe, (rdn_non_zero_ O -> rdn_non_zero_ (rdn_ (rdnn_ D) O))).
Variable less_entry_point_pos_pos_550 : (forall X Y RDN_X RDN_Y : Universe, ((rdn_translate_ X (rdn_pos_ RDN_X) /\ (rdn_translate_ Y (rdn_pos_ RDN_Y) /\ rdn_positive_less_ RDN_X RDN_Y)) -> less_ X Y)).
Variable less_entry_point_neg_pos_551 : (forall X Y RDN_X RDN_Y : Universe, ((rdn_translate_ X (rdn_neg_ RDN_X) /\ rdn_translate_ Y (rdn_pos_ RDN_Y)) -> less_ X Y)).
Variable less_entry_point_neg_neg_552 : (forall X Y RDN_X RDN_Y : Universe, ((rdn_translate_ X (rdn_neg_ RDN_X) /\ (rdn_translate_ Y (rdn_neg_ RDN_Y) /\ rdn_positive_less_ RDN_Y RDN_X)) -> less_ X Y)).
Variable less_property_553 : (forall X Y : Universe, (less_ X Y <-> (~(less_ Y X) /\ Y <> X))).
Variable less_or_equal_554 : (forall X Y : Universe, (less_or_equal_ X Y <-> (less_ X Y \/ X = Y))).
Variable less_successor_555 : (forall X Y Z : Universe, ((sum_ X n1_ Y /\ less_ Z Y) -> less_or_equal_ Z X)).

Set Firstorder Depth 10.

Theorem query_26_556 : (exists X Y : Universe, ~(accept_population_ X Y n100_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
