#!/usr/bin/octave

disp("Tests for  u_t-u_{xx}=f Dir bnd u(0,x)=u0(x); e.g. f=0 and u(t,x)=exp(-t)sin(x)");
disp("linear FEM discretizations and implicit Euler or Crank-N in time ");


a=-2;b=1;
M0=M=3;#initial no of meshpoints -1 (M0-1 interior points)
Nt=3; #initial no of time steps
NoR=5; #no of refinement
em=e0=zeros(NoR,1);
f=@(t,x) zeros(size(x));
s=@(t,x) exp(-t)*sin(x);
sb=@(t) s(t,[a;b]);

f1=@(t,x) exp(-t).*(-2-x.*x);
s1=@(t,x) exp(-t).*x.*x;
sb1=@(t) s1(t,[a;b]);

f2=@(t,x) 3*exp(-t).*(cos(2*x));
s2=@(t,x) exp(-t).*(cos(2*x));
sb2=@(t) s2(t,[a;b]);


f3=@(t,x) (1+2)*ones(size(x));
s3=@(t,x) t-x.*x;
sb3=@(t) s3(t,[a;b]);


#equidistant mesh
 x=linspace(a,b,M+1)'; 
# [u,gr,h,L,Ma]=FEM1Dsolver(@(x) 0,a,b,x',al=0,be=0,c=0,ad=0,di=1.0);
# u0=sin(x);
# [X,t]=ImEulerP(u0,x,Ma,L,Nt=8,T=1,f2,sb2,rindt=1:Nt+1);
# mesh(X');pause(1);
#sinusoidal mesh i.e. sin(x_k) x_k equaidistant on pi*[-0,5,0.5] 
# x=linspace(-0.5*pi,0.5*pi,M+1);
# x=0.5*(a+b)+0.5*(b-a)*sin(x);

for k=1:NoR,
 sol=s1; f=f1;sb=sb1;
 sol=s2; f=f2;sb=sb2;
# sol=s3; f=f3;sb=sb3;
 Nt*=4; #for implicit Euler
# Nt*=2; #for Crank Nicholson
 #mesh refinement
 y=0.5*(x(2:M+1)+x(1:M));
 xn=zeros(2*M+1,1);
 xn(1:2:2*M+1)=x;
 xn(2:2:2*M)=y;
 x=xn;M*=2;
 
 [u,gr,h,L,Ma]=FEM1Dsolver(@(x) 0,a,b,x',al=0,be=0,c=0,ad=0,di=1.0);
 hh(k)=h;
 u0=sol(0,x);
 #Implicit Euler
 [X,t,tau]=ImEulerP(u0,x,Ma,L,Nt,T=1,f,sb,rindt=Nt+1);
 #Implicit Crank Nicholson (divide h/2 then - it had 2nd order conv in time too
 #[X,t,tau]=CrankNP(u0,x,Ma,L,Nt,T=1,f,sb,rindt=Nt+1);
 
 plot(x',u0,x',X');pause(1);
 tauu(k)=tau;
 em(k)=norm(X'-sol(T,x),'inf'); #max norm for T
 e0(k)=sqrt(h)*norm(X'-sol(T,x),2);
endfor
 bledy=[em e0]
 ratioinmax=em(1:NoR-1)./em(2:NoR)
 ratioinL2=e0(1:NoR-1)./e0(2:NoR)
 #experiments confirm that implicit Euler in this case
 #has convergence  1st order  in time and 2nd order in space


 
