#!/usr/bin/octave

disp("Tests for  u_t-u_{xx}=f Dir bnd u(0,x)=u0(x); e.g. f=0 and u(t,x)=exp(-t)sin(x)");
disp("FDM discretizations and implicit Crank-Nicholson in time ");



a=0;b=4;
M0=M=3;#initial no of meshpoints -1 (M0-1 interior points)
Nt=10; #initial no of time steps
NoR=5; #no of refinement
em=e0=zeros(NoR,1);
f=@(t,x) zeros(size(x));
s=@(t,x) exp(-t)*sin(x);
sb=@(t) s(t,[a;b]);

f1=@(t,x) exp(-t).*(-2-x.*x);
s1=@(t,x) exp(-t).*x.*x;
sb1=@(t) s1(t,[a;b]);

f2=@(t,x) 3*exp(-t).*(cos(2*x));
s2=@(t,x) exp(-t).*(cos(2*x));
sb2=@(t) s2(t,[a;b]);


f3=@(t,x) (1+2)*ones(size(x));
s3=@(t,x) t-x.*x;
sb3=@(t) s3(t,[a;b]);


#equidistant mesh
 x=linspace(a,b,M+1)'; 
 h=(b-a)/M;
#-Laplacian matrix (scaled by h)
 Ma=L=sparse(M+1,M+1);
 L(2:M,2:M)=(2)*sparse(diag(ones(M-1,1)))- sparse(diag(ones(M-2,1),1)) - sparse(diag(ones(M-2,1),-1));
 L(2,1)=L(M,M+1)=-1;L/=h;  Ma(2:M,2:M)=h*speye(M-1,M-1);
 u0=s(0,x);
# [X,t]=ImEulerP(u0,x,Ma,L,Nt=8,T=1,f,sb,rindt=1:Nt+1);
  [X,t]=ExEulerP(u0,x,Ma,L,Nt=8,T=1,f,sb,rindt=1:Nt+1);
  [X,t]=CrankNP(u0,x,Ma,L,Nt=8,T=1,f,sb,rindt=1:Nt+1);
# mesh(X');pause(1);

for k=1:NoR, 
 sol=s;
 sol=s1; f=f1;sb=sb1;
 sol=s2; f=f2;sb=sb2;
# sol=s3; f=f3;sb=sb3; #error zero + rounding errors
 Nt*=2;
 M*=2;
 x=linspace(a,b,M+1)';
 h=(b-a)/M;
 #-Laplacian matrix (scaled by h)
 Ma=L=sparse(M+1,M+1);
 L(2:M,2:M)=(2)*sparse(diag(ones(M-1,1)))- sparse(diag(ones(M-2,1),1)) - sparse(diag(ones(M-2,1),-1));
 L(2,1)=L(M,M+1)=-1;L/=h;  Ma(2:M,2:M)=h*speye(M-1,M-1);
 u0=sol(0,x);
# [u,gr,h,LF,MaF]=FEM1Dsolver(@(x) 0,a,b,x');
# erL(k)=norm(L(2:M,:)-LF(2:M,:),1);
 [X,t,tau]=CrankNP(u0,x,Ma,L,Nt,T=1,f,sb,rindt=Nt+1);
 plot(x',u0,x',X');pause(1);
# [X,t,tau]=ImEulerP(u0,Ma,L,Nt,T=1,rindt=Nt+1);
 tauu(k)=tau;
 em(k)=norm(X'-sol(T,x),'inf'); #max norm for T
 e0(k)=sqrt(h)*norm(X'-sol(T,x),2);
endfor
 bledy=[em e0]
 ratioinmax=em(1:NoR-1)./em(2:NoR)
 ratioinL2=e0(1:NoR-1)./e0(2:NoR)
 #experiments confirm that Crank-Nicholson in this case
 #has convergence  2nd order  in time and 2nd order in space


 
