
function [X,t,tau]=ExEulerP(u0,x,Ma,L,Nt=10,T=1,f=@(t,x) 0,ubnd=@(t) [0;0],rindt=1:Nt+1,rindx=1:length(u0))
#impicit Euler solver for 1D FEM discretization of  u_t=u_{xx}+f 
#u(t,a),u(t,b) given u(0,x)=u0(x)
#Ma*(X(n+1,:)-X(n,:))/tau + L*X(n,:)=f(n,X(n,:)) in interior 
#INPUT
#u0 - initial value vector wit hvalues at nodes of x
#x - mesh including ends i.e. x=[a,x_2,..,X_M,b] 
#    in case of FDM mesh must equidistant
#L Ma stiffness and mass matrix for 1D FEM on mesh of x/ OR 
#L FDM disretized Laplacian scaled by h and Ma=Id*h for equdistant FDM
#(x must be a vector of equaidistant mesh on [a,b]) 
#f - function handle to f(t,x) rhs 
#ubnd - function handles to function ubnd which returns two bnd values at t
#        i.e. ubnd(t)=[u(t,a);u(t,b)]
#rindt - time steps returned (default all) 
#rindx - space mesh indices  returned in X (default all)
#OUTPUT
#X - Nt+1 x length(u0) matrix 
#i-th row represents approximation of interior nodal values 
#for t=(i-1)*tau
#Example:
#[X]=ExEulerP(u0,Ma,L);
#[X,t,tau]=ExEulerP(u0,Ma,L,Nt=10,T=1,rindt=Nt+1) - returned is only the last
#time step i.e. for t=T
tau=T/Nt;
M=length(u0)-1;
ind=1:M+1;
iind=2:M;
bnd=setdiff(ind,iind); #bnd indices
X=zeros(Nt+1,M+1);
F=sparse(M+1,1);  #only interior points
xbnd=sparse(M+1,1);#xbnd vector equal to zero in interior nodes
                 #and having the proper bnd values
t=linspace(0,T,Nt+1);
X(1,:)=u0';
#IdmtauL=Ma-tau*L;
LL=L(iind,iind);
MMa=Ma(iind,iind); #interior submatrices
hh=x(2:M+1)-x(1:M);    #the vector with segemnts lengths
w=0.5*([hh;0]+[0;hh]); #weights for trapezoidal quadrature rule
#sum(w)==b-a #test if weights are OK
for k=2:Nt+1,
 F=tau*(w.*f(t(k-1),x))(iind);#the rhs of equation scaled by tau and weights
 X(k,bnd)=xbnd(bnd)=ubnd(t(k)); #setting bnd values
 F= F + (Ma*(X(k-1,:)'- xbnd) - L*(tau*X(k-1,:)'))(iind); 
 #tau(f,v)=tau(f,v) + (u_k-ubnd,v) - tau a(u_k,v)
 X(k,iind)=( MMa\F )';
# X(k,iind)=( X(k-1,iind)'- MMa\(tau*LL* X(k-1,iind)') )'; #old - interior values bnd zero F=0
endfor
X=X(rindt,rindx);
endfunction


