
function [X,t,tau]=CrankNP(u0,x,Ma,L,Nt=10,T=1,f=@(t,x) 0,ubnd=@(t) [0;0],rindt=1:Nt+1,rindx=1:length(u0))
#impicit Crank-Nicholson solver for 1D FEM discretization of  u_t=u_{xx}+f 
#u(t,a),u(t,b) given u(0,x)=u0(x)
#Ma*(X(n+1,:)-X(n,:))/tau + 0.5*L*(X(n+1,:)+X(n,:)=
#                      0.5*(f(n+1,X(n+1,:)+f(n,X(n,:)) in interior 
#INPUT
#u0 - initial value vector wit hvalues at nodes of x
#x - mesh including ends i.e. x=[a,x_2,..,X_M,b] 
#    in case of FDM mesh must equidistant
#L Ma stiffness and mass matrix for 1D FEM on mesh of x/ OR 
#L FDM disretized Laplacian scaled by h and Ma=Id*h for equdistant FDM
#(x must be a vector of equaidistant mesh on [a,b]) 
#f - function handle to f(t,x) rhs 
#ubnd - function handles to function ubnd which returns two bnd values at t
#        i.e. ubnd(t)=[u(t,a);u(t,b)]
#rindt - time steps returned (default all) 
#rindx - space mesh indices  returned in X (default all)
#OUTPUT
#X - Nt+1 x length(u0) matrix 
#i-th row represents approximation of interior nodal values 
#for t=(i-1)*tau
#Example:
#[X]=CrankNP(u0,Ma,L);
#[X,t,tau]=CrankNP(u0,Ma,L,Nt=10,T=1,rindt=Nt+1) - returned is only the last
#time step i.e. for t=T
tau=T/Nt;
M=length(u0)-1;
ind=1:M+1;
iind=2:M;
bnd=setdiff(ind,iind); #bnd indices
X=zeros(Nt+1,M+1);
F=sparse(M+1,1);  #only interior points
xbnd=sparse(M+1,1);#xbnd vector equal to zero in interior nodes
                 #and havung th eproper bnd values
t=linspace(0,T,Nt+1);
X(1,:)=u0';
#IdmtauL=Ma-tau*L;
LL=L(iind,iind);MMa=Ma(iind,iind); #interior submatrices
hh=x(2:M+1)-x(1:M);    #the vector with segemnts lengths
w=0.5*([hh;0]+[0;hh]); #weights for trapezoidal quadrature rule
#sum(w)=b-a #test if weights are OK
Fkm1=tau*(w.*f(t(1),x))(iind);
for k=2:Nt+1,
 Fk=tau*(w.*f(t(k),x))(iind);#the rhs of equation scaled by tau and weights
 F=0.5*(Fkm1+Fk);Fkm1=Fk; 
 X(k,bnd)=xbnd(bnd)=ubnd(t(k)); #setting bnd values
#imEuler F= F + (Ma*(X(k-1,:)'- xbnd)- L*(tau*xbnd))(iind);
 F=F+  (Ma*(X(k-1,:)'- xbnd) - L*((0.5*tau)*(X(k-1,:)'+ xbnd)))(iind);
 #tau(f,v)=tau(f,v) + (u_n-ubnd,v) -tau a(ubnd,v)
 X(k,iind)=( (MMa+0.5*tau*LL)\F )';
endfor
X=X(rindt,rindx);
endfunction


function L=FDMlaplacian1d(a,b,M)
#creates 1D FDM Laplacian matrix on M+1 equidistant points on [a,b]  
#including all points for 3 point stencil for all interior points (1st/last rows are zero)
#in case of neumann bnd we can add entries at the 1st/lst row respectively
#equidistant mesh
 x=linspace(a,b,M+1)'; 
 h=(b-a)/M;
#-Laplacian matrix (scaled by h)
 Ma=L=sparse(M+1,M+1);
 L(2:M,2:M)=(2)*sparse(diag(ones(M-1,1)))- sparse(diag(ones(M-2,1),1)) - sparse(diag(ones(M-2,1),-1));
 L(2,1)=L(M,M+1)=-1;L/=h;  Ma(2:M,2:M)=h*speye(M-1,M-1);

endfunction



function Ma=FDMmass(a,b,M)

#equidistant mesh
 x=linspace(a,b,M+1)'; 
 h=(b-a)/M;
#-Laplacian matrix (scaled by h)
 Ma=L=sparse(M+1,M+1);
 L(2:M,2:M)=(2)*sparse(diag(ones(M-1,1)))- sparse(diag(ones(M-2,1),1)) - sparse(diag(ones(M-2,1),-1));
 L(2,1)=L(M,M+1)=-1;L/=h;  Ma(2:M,2:M)=h*speye(M-1,M-1);

endfunction

